/**
 * Jquery-UI - A GWT library implementation of the Javascript library Jquery-ui - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.jquery.client.core;



import com.ebmwebsourcing.gwt.jquery.client.ui.Draggable;
import com.ebmwebsourcing.gwt.jquery.client.ui.Droppable;
import com.ebmwebsourcing.gwt.jquery.client.ui.Resizable;
import com.ebmwebsourcing.gwt.jquery.client.ui.Selectable;
import com.ebmwebsourcing.gwt.jquery.client.ui.Sortable;
import com.ebmwebsourcing.gwt.jquery.client.ui.handler.DragHandler;
import com.ebmwebsourcing.gwt.jquery.client.ui.handler.DropHandler;
import com.ebmwebsourcing.gwt.jquery.client.ui.handler.ResizableHandler;
import com.ebmwebsourcing.gwt.jquery.client.ui.handler.SelectableHandler;
import com.ebmwebsourcing.gwt.jquery.client.ui.handler.SortableHandler;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.user.client.Element;
import com.j4g.client.core.J4G;

public class J4GUI extends J4G{
	

	private Draggable draggable 	= new Draggable();
	
	private Droppable droppable 	= new Droppable();
	
	private Resizable resizable 	= new Resizable();
	
	private Selectable selectable 	= new Selectable();
	
	private Sortable sortable		= new Sortable();
	
	
	private String key;
	
	
	
	public J4GUI(String key) {
		this.key = key;
	}
	
	
	
	///////////////////////
	// SORTABLE
	//////////////////////////
	
	public J4GUI sortable(){
		sortable.sortable(key);
		return this;
	}
	
	public J4GUI sortable(SortableHandler sortableHandler){
		
		this.sortable();
		
		if (sortableHandler.start()  		!=null ) this.bind("sortstart", sortableHandler.start());
		if (sortableHandler.sort()   		!=null ) this.bind("sort", sortableHandler.sort());
		if (sortableHandler.change()  		!=null ) this.bind("sortchange", sortableHandler.change());
		if (sortableHandler.beforeStop()  	!=null ) this.bind("sortbeforeStop", sortableHandler.beforeStop());
		if (sortableHandler.stop()			!=null ) this.bind("sortstop", sortableHandler.stop());
		if (sortableHandler.update()		!=null ) this.bind("sortupdate", sortableHandler.update());
		if (sortableHandler.receive()		!=null ) this.bind("sortreceive", sortableHandler.receive());
		if (sortableHandler.remove()		!=null ) this.bind("sortremove", sortableHandler.remove());
		if (sortableHandler.over()			!=null ) this.bind("sortover", sortableHandler.over());
		if (sortableHandler.out()			!=null ) this.bind("sortout", sortableHandler.out());
		if (sortableHandler.activate()		!=null ) this.bind("sortactivate", sortableHandler.activate());
		if (sortableHandler.deactivate()	!=null ) this.bind("sortdeactivate", sortableHandler.deactivate());
		
		
		
		return this;
	}	
	
	
	public J4GUI sortableAppendTo(String selector){
		
		sortable.setsortableOption(key, "appendTo", selector);
		
		return this;
	}
	

	public J4GUI sortableAxis(AxisType axistype){
		
		sortable.setsortableOption(key, "appendTo", axistype.getValue());
		
		return this;
	}
	
	
	public J4GUI sortableCancel(String selector){
		
		sortable.setsortableOption(key, "cancel", selector);
		
		return this;
	}

	
	public J4GUI sortableConnectWith(String selector){
		
		sortable.setsortableOption(key, "connectWith", selector);
		
		return this;
	}

	
	public J4GUI sortableContainment(Element element){
		
		sortable.setsortableOption(key, "containment", element);
		
		return this;
	}
	
	
	public J4GUI sortableContainment(ContainmentZoneType containment){
		
		sortable.setsortableOption(key, "containment", containment.getValue());
		
		return this;
	}
	
	public J4GUI sortableContainment(String selector){
		
		sortable.setsortableOption(key, "containment", selector);
		
		return this;
	}
	
	public J4GUI sortableCursor(String cursor){
		
		sortable.setsortableOption(key, "cursor", cursor);
		
		return this;
	}

	public J4GUI sortableCursorAt(CursorAt cursorat){
		
		sortable.setsortableOption(key, "cursorAt", cursorat.getJSON());
		
		return this;
	}	
	

	public J4GUI sortableDelay(int delay){
		
		sortable.setsortableOption(key, "delay", delay);
		
		return this;
	}
	
	
	public J4GUI sortableDistance(int distance){
		
		sortable.setsortableOption(key, "distance", distance);
		
		return this;
	}	

	public J4GUI sortableDropOnEmpty(boolean droponempty){
		
		sortable.setsortableOption(key, "dropOnEmpty", droponempty);
		
		return this;
	}	

	public J4GUI sortableForceHelperSize(boolean forcehelpersize){
		
		sortable.setsortableOption(key, "forceHelperSize", forcehelpersize);
		
		return this;
	}	
	
	
	public J4GUI sortableForcePlaceHolderSize(boolean forceplaceholdersize){
		
		sortable.setsortableOption(key, "forcePlaceholderSize", forceplaceholdersize);
		
		return this;
	}
	
	public J4GUI sortableGrid(int x,int y){
		
		sortable.setsortableOption(key, "grid", "["+x+","+y+"]");
		
		return this;
	}
	
	public J4GUI sortableHandle(String selector){
		
		sortable.setsortableOption(key, "handle", selector);
		
		return this;
	}
	
	public J4GUI sortableHandle(Element element){
		
		sortable.setsortableOption(key, "handle", element);
		
		return this;
	}
	
	
	public J4GUI sortableHelper(HelperType helper){
		
		sortable.setsortableOption(key, "helper", helper.getValue());
		
		return this;
	}
	
	
	public J4GUI sortableItems(String selector){
		
		sortable.setsortableOption(key, "items", selector);
		
		return this;
	}
	
	
	public J4GUI sortableOpacity(float opacity){
		
		sortable.setsortableOption(key, "opacity", opacity);
		
		return this;
	}

	
	public J4GUI sortablePlaceHolder(String classname){
		
		sortable.setsortableOption(key, "placeholder", classname );
		
		return this;
	}

	
	public J4GUI sortableRevert(boolean revert){
		
		sortable.setsortableOption(key, "revert", revert);
		
		return this;
	}

	
	public J4GUI sortableScroll(boolean scroll){
		
		sortable.setsortableOption(key, "scroll", scroll);
		
		return this;
	}
	
	
	public J4GUI sortableScrollSensivity(int scrollsensivity){
		
		sortable.setsortableOption(key, "scrollSensivity", scrollsensivity);
		
		return this;
	}	
	
	
	public J4GUI sortableScrollSpeed(int scrollspeed){
		
		sortable.setsortableOption(key, "scrollSpeed", scrollspeed);
		
		return this;
	}	
	
	public J4GUI sortableTolerance(ToleranceMode tolerance){
		
		sortable.setsortableOption(key, "tolerance", tolerance.getValue());
		
		return this;
	}	
	
	
	public J4GUI sortableZIndex(int zindex){
		
		sortable.setsortableOption(key, "zIndex", zindex);
		
		return this;
	}		
	
	
	///////////////////////
	// SELECTABLE
	//////////////////////////
	
	public J4GUI selectable(){
		selectable.selectable(key);
		return this;
	}
	
	public J4GUI selectable(SelectableHandler selectableHandler){
		
		this.selectable();
		
		if (selectableHandler.selected() 	!=null ) 	this.bind("selectableselected", selectableHandler.selected());
		if (selectableHandler.selecting() 	!=null ) 	this.bind("selectableselecting", selectableHandler.selecting());
		if (selectableHandler.start() 		!=null ) 	this.bind("selectablestart", selectableHandler.start());
		if (selectableHandler.stop() 		!=null ) 	this.bind("selectablestop", selectableHandler.stop());
		if (selectableHandler.unselected() 	!=null ) 	this.bind("selectableunselected", selectableHandler.unselected());
		if (selectableHandler.unselecting() !=null ) 	this.bind("selectableunselecting", selectableHandler.unselecting());
		
		
		selectable.selectable(key);

		return this;
	}	
	
	
	
	public J4GUI selectableAutoRefresh(boolean autorefresh){
		
		selectable.setselectableOption(key, "autoRefresh", autorefresh);
		
		return this;
	}
	
	public J4GUI selectableCancel(String selector){
		
		selectable.setselectableOption(key, "cancel", selector);
		
		return this;
	}
	
	public J4GUI selectableDelay(int delay){
		
		selectable.setselectableOption(key, "delay", delay);
		
		return this;
	}	
	
	
	public J4GUI selectableDistance(int distance){
		
		selectable.setselectableOption(key, "distance", distance);
		
		return this;
	}
	
	
	public J4GUI selectableFilter(String selector){
		
		selectable.setselectableOption(key, "filter", selector);
		
		return this;
	}
	
	
	public J4GUI selectableTolerance(ToleranceMode tolerance){
		
		selectable.setselectableOption(key, "cancel", tolerance.getValue());
		
		return this;
	}
	

	///////////////////////
	// RESIZABLE
	//////////////////////////
	
	public J4GUI resizable(){
		resizable.resizable(key);
		return this;
	}
	
	public J4GUI resizable(ResizableHandler resizeHandler){
		
		this.resizable();
		
		if (resizeHandler.start() 	!=null ) this.bind("resizestart", resizeHandler.start());
		if (resizeHandler.resize() 	!=null ) this.bind("resize", resizeHandler.resize());
		if (resizeHandler.stop() 	!=null ) this.bind("resizestop", resizeHandler.stop());

		resizable.resizable(key);

		return this;
	}
	
	
	
	
	
	public J4GUI rezisableAlsoResize(String selector){
		
		resizable.setresizableOption(key, "alsoResize", selector);
		
		return this;
		
	}
	
	
	public J4GUI rezisableAlsoResize(Element element){
		
		resizable.setresizableOption(key, "alsoResize", element);
		
		return this;
		
	}
	
	
	public J4GUI rezisableAnimate(boolean animate){
		
		resizable.setresizableOption(key, "animate", animate);
		
		return this;
		
	}
	
	
	public J4GUI rezisableAnimateDuration(int animateDuration){
		
		resizable.setresizableOption(key, "animateDuration", animateDuration);
		
		return this;
		
	}
	
	
	public J4GUI rezisableAnimateDuration(AnimateDuration animateDuration){
		
		resizable.setresizableOption(key, "animateDuration", animateDuration.getValue());
		
		return this;
		
	}
	
	public J4GUI resizableAnimateEasing(String animateeasing){
		
		resizable.setresizableOption(key, "animateEasing", animateeasing);
		
		return this;
		
	}
	
	
	public J4GUI resizableAspectRation(boolean aspectratio){
		
		resizable.setresizableOption(key, "aspectRatio", aspectratio);
		
		return this;
		
	}	
	
	public J4GUI resizableAspectRation(float aspectratio){
		
		resizable.setresizableOption(key, "aspectRatio", aspectratio);
		
		return this;
		
	}
	
	public J4GUI resizableAutoHide(boolean autohide){
		
		resizable.setresizableOption(key, "autoHide", autohide);
		
		return this;
		
	}	
	

	public J4GUI resizableCancel(String selector){
		
		resizable.setresizableOption(key, "cancel", selector);
		
		return this;
		
	}		
	

	public J4GUI resizableContainment(String selector){
		
		resizable.setresizableOption(key, "containment", selector);
		
		return this;
		
	}		
	

	public J4GUI resizableContainment(ContainmentZoneType containment){
		
		resizable.setresizableOption(key, "containment", containment.getValue());
		
		return this;
		
	}
	
	
	public J4GUI resizableContainment(Element element){
		
		resizable.setresizableOption(key, "containment", element);
		
		return this;
		
	}	
	
	
	public J4GUI resizableDelay(int delay){
		
		resizable.setresizableOption(key, "delay", delay);
		
		return this;
		
	}
	
	
	public J4GUI resizableDistance(int distance){
		
		resizable.setresizableOption(key, "distance", distance);
		
		return this;
		
	}
	
	
	public J4GUI resizableGhost(boolean ghost){
		
		resizable.setresizableOption(key, "distance", ghost);
		
		return this;
		
	}
	
	
	public J4GUI resizableGrid(int x,int y){
		
		resizable.setresizableOption(key, "grid", "["+x+","+y+"]");
		
		return this;
		
	}
	
	
	public J4GUI resizableHandles(String handles){
		
		resizable.setresizableOption(key, "handles", handles );
		
		return this;
		
	}
	
	
	
	public J4GUI resizableHelper(String cssClass){
		
		resizable.setresizableOption(key, "helper", cssClass);
		
		return this;
		
	}
	
	
	public J4GUI resizableMaxHeight(int maxheight){
		
		resizable.setresizableOption(key, "maxHeight", maxheight);
		
		return this;
		
	}	
	
	public J4GUI resizableMaxWidth(int maxwidth){
		
		resizable.setresizableOption(key, "maxWidth", maxwidth);
		
		return this;
		
	}
	
	public J4GUI resizableMinHeight(int minHeight){
		
		resizable.setresizableOption(key, "minHeight", minHeight);
		
		return this;
		
	}
	
	
	public J4GUI resizableMinWisth(int minwidth){
		
		resizable.setresizableOption(key, "minWidth", minwidth);
		
		return this;
		
	}
	
	
	
	///////////////////////
	// DRAGGABLE
	//////////////////////////
	
	public J4GUI draggable(){
		draggable.draggable(key);
		return this;
	}
	
	
	public J4GUI draggable(DragHandler dragHandler){
		
		this.draggable();
		
		if (dragHandler.start() !=null) 	this.bind("dragstart", dragHandler.start());
		if (dragHandler.stop() 	!=null) 	this.bind("dragstop", dragHandler.stop());
		if (dragHandler.drag() 	!=null) 	this.bind("drag", dragHandler.drag());
		
		return this;
	}
	
	/**
	 * Remove the draggable functionality completely. <br> This will return the element back to its pre-init state.
	 * @return J4GUI
	 */
	public J4GUI destroyDraggable(){
		draggable.draggable(key, "destroy");
		return this;
	}
	
	/**
	 * Disable the draggable.
	 * @return J4GUI
	 */
	public J4GUI disableDraggable(){
		draggable.draggable(key,"disable");
		return this;
	}
	
	/**
	 * Enable the draggable.
	 * @return
	 */
	public J4GUI enableDraggable(){
		draggable.draggable(key,"enable");
		return this;
	}
	
	/**
	 * If set to false, will prevent the ui-draggable class from being added. <br>
	 * This may be desired as a performance optimization when calling .draggable() <br>
	 * init on many hundreds of elements.<br>
	 * Default: true
	 * 
	 * @param boolean addclasses
	 * @return J4GUI
	 */
	public J4GUI draggableAddClasses(boolean addclasses){
		draggable.setdraggableOption(key, "addClasses", addclasses);
		return this;
	}
	
	/**
	 * The element passed to or selected by the appendTo option will be used as <br>
	 * the draggable helper's container during dragging. By default, the helper <br>
	 * is appended to the same container as the draggable.<br>
	 * Default : 'parent'
	 * 
	 * @param Element element
	 * @return J4GUI
	 */
	public J4GUI draggableAppendTo(Element element){
		draggable.setdraggableOption(key, "appendTo", element);
		return this;
	}


	/**
	 * The element passed to or selected by the appendTo option will be used as <br>
	 * the draggable helper's container during dragging. By default, the helper <br>
	 * is appended to the same container as the draggable.<br>
	 * Default : 'parent'
	 * 
	 * @param String css selector
	 * @return J4GUI
	 */	
	public J4GUI draggableAppendTo(String selector){
		draggable.setdraggableOption(key, "appendTo", selector);
		return this;
	}
	
	/**
	 * Constrains dragging to either the horizontal (x) or vertical (y) axis.<br>
	 * Possible values: 'x', 'y'.<br>
	 * Default: false 
	 * 
	 * @param AxisType axis
	 * @return J4GUI
	 */
	public J4GUI draggableAxis(AxisType axis){
		draggable.setdraggableOption(key, "axis", axis.getValue());
		return this;
	}
	
	/**
	 * Prevents dragging from starting on specified elements.<br>
	 * Default: 'input,option'
	 * 
	 * @param String selector
	 * @return J4GUI
	 */
	public J4GUI draggableCancel(String selector){
		draggable.setdraggableOption(key, "cancel", selector);
		return this;
	}
	
	/**
	 * Allows the draggable to be dropped onto the specified sortables. <br>
	 * If this option is used (helper must be set to 'clone' in order to work flawlessly),<br>
	 * a draggable can be dropped onto a sortable list and then becomes part of it.<br>
	 * Default: false
	 * 
	 * @param String selector
	 * @return J4GUI
	 */
	public J4GUI draggableConnectToSortable(String selector){
		draggable.setdraggableOption(key, "connectToSortable", selector);
		return this;
	}
	
	/**
	 * Constrains dragging to within the bounds of the specified element or region.<br>
	 * Possible string values: 'parent', 'document', 'window', [x1, y1, x2, y2].<br>
	 * Default:false
	 * 
	 * @param String css selector
	 * @return J4GUI
	 */
	public J4GUI draggableContainment(String selector){
		draggable.setdraggableOption(key, "containment", selector);
		return this;
	}

	/**
	 * Constrains dragging to within the bounds of the specified element or region.<br>
	 * Possible string values: 'parent', 'document', 'window', [x1, y1, x2, y2].<br>
	 * Default:false
	 * 
	 * @param Element element
	 * @return J4GUI
	 */	
	public J4GUI draggableContainment(Element element){
		draggable.setdraggableOption(key, "containment", element);
		return this;
	}
	
	/**
	 * Constrains dragging to within the bounds of the specified element or region.<br>
	 * Possible string values: 'parent', 'document', 'window', [x1, y1, x2, y2].<br>
	 * Default:false
	 * 
	 * @param ContainmentZone zone
	 * @return J4GUI
	 */
	public J4GUI draggableContainment(ContainmentZone zone){
		draggable.setdraggableOption(key, "containment", "["+zone.getX1()+","+zone.getY1()+","+zone.getX2()+","+zone.getY2()+"]");
		return this;
	}

	/**
	 * Constrains dragging to within the bounds of the specified element or region.<br>
	 * Possible string values: 'parent', 'document', 'window', [x1, y1, x2, y2].<br>
	 * Default:false
	 * 
	 * @param ContainmentZoneType zone
	 * @return J4GUI
	 */
	public J4GUI draggableContainment(ContainmentZoneType zone){
		draggable.setdraggableOption(key, "containment", zone.getValue());
		return this;
	}	
	
	/**
	 * The css cursor during the drag operation.
	 * @param String cursorType
	 * @return J4GUI
	 */
	public J4GUI draggableCursor(String cursorType){
		draggable.setdraggableOption(key, "cursor", cursorType);
		return this;
	}
	
	
	public J4GUI draggableCursorAt(CursorAt cursorAt){
		draggable.setdraggableOption(key, "cursorAt",cursorAt.getJSON());
		return this;
	}
	
	
	public J4GUI draggableDelay(int delay){
		draggable.setdraggableOption(key, "delay", delay);
		return this;
	}
	

	public J4GUI draggableDistance(int delay){
		draggable.setdraggableOption(key, "distance", delay);
		return this;
	}

	
	public J4GUI draggableGrid(int x,int y){
		draggable.setdraggableOption(key, "grid", "["+x+","+y+"]");
		return this;
	}

	
	public J4GUI draggableHandle(Element element){
		draggable.setdraggableOption(key, "handle", element);
		return this;
	}

	
	public J4GUI draggableHandle(String selector){
		draggable.setdraggableOption(key, "handle", selector);
		return this;
	}
	
	
	public J4GUI draggableHelper(HelperType helper){
		draggable.setdraggableOption(key, "helper", helper.getValue());
		return this;
	}
	
	
	public J4GUI draggableIFrameFix(boolean iframefix){
		draggable.setdraggableOption(key, "iframefix", iframefix);
		return this;
	}
	
	
	public J4GUI draggableIFrameFix(String selector){
		draggable.setdraggableOption(key, "iframefix", selector);
		return this;
	}
	
	
	public J4GUI draggableOpacity(float opacity){
		draggable.setdraggableOption(key, "opacity", opacity);
		return this;
	}
	
	
	public J4GUI draggableRefreshPositions(boolean refreshPositions){
		draggable.setdraggableOption(key, "refreshPositions", refreshPositions);
		return this;
	}
	
	
	public J4GUI draggableRevert(boolean revert){
		draggable.setdraggableOption(key, "revert", revert);
		return this;
	}
	
	
	public J4GUI draggableRevert(RevertType type){
		draggable.setdraggableOption(key, "revert", type.getValue());
		return this;
	}
	
	
	public J4GUI draggableRevertDuration(int revertDuration){
		draggable.setdraggableOption(key, "revertDuration", revertDuration);
		return this;
	}
	
	
	public J4GUI draggableScope(String scope){
		draggable.setdraggableOption(key, "scope", scope);
		return this;
	}

		
	public J4GUI draggableScroll(boolean scroll){
		draggable.setdraggableOption(key, "scroll", scroll);
		return this;
	}

	public J4GUI draggableScrollSensivity(int scrollSensivity){
		draggable.setdraggableOption(key, "scrollSensitivity", scrollSensivity);
		return this;
	}	
	
	public J4GUI draggableScrollSpeed(int scrollSpeed){
		draggable.setdraggableOption(key, "scrollSpeed", scrollSpeed);
		return this;
	}
	
	public J4GUI draggableSnap(boolean snap){
		draggable.setdraggableOption(key, "snap", snap);
		return this;
	}	
	
	public J4GUI draggableSnap(String selector){
		draggable.setdraggableOption(key, "snap", selector);
		return this;
	}
	
	
	public J4GUI draggableSnapMode(SnapMode snapMode){
		draggable.setdraggableOption(key, "snapMode", snapMode.getValue());
		return this;
	}	
	
	
	public J4GUI draggableSnapTolerance(int snapTolerance){
		draggable.setdraggableOption(key, "snapTolerance", snapTolerance);
		return this;
	}	
	
	
	public J4GUI draggableStack(JSONObject stack){
		draggable.setdraggableOption(key, "stack", stack);
		return this;
	}	
	
	
	
	public J4GUI draggablezIndex(int zindex){
		draggable.setdraggableOption(key, "zIndex", zindex);
		return this;
	}	
	
	
	
	
	///////////////////////
	// DROPPABLE
	//////////////////////////
	
	
	public J4GUI droppable(){
		droppable.droppable(key);
		return this;
	}
	
	
	public J4GUI droppable(DropHandler dropHandler){
		
		this.droppable();
		
		if (dropHandler.activate() 		!=	null) 			this.bind("dropactivate", dropHandler.activate());
		if (dropHandler.deactivate() 	!=	null) 			this.bind("dropdeactivate", dropHandler.deactivate());
		if (dropHandler.over() 			!=	null) 			this.bind("dropover", dropHandler.over());
		if (dropHandler.out() 			!=	null) 			this.bind("dropout", dropHandler.out());
		if (dropHandler.drop() 			!=	null) 			this.bind("drop", dropHandler.drop());
		
		return this;
	}
	
	
	/**
	 * Remove the droppable functionality completely.<br>
	 * This will return the element back to its pre-init state.
	 * @return J4GUI 
	 */
	public J4GUI destroyDroppable(){
		droppable.droppable(key, "destroy");
		return this;
	}
	
	/**
	 * Disable the droppable.
	 * @return J4GUI
	 */
	public J4GUI disableDroppable(){
		droppable.droppable(key, "disable");
		return this;
	}
	
	/**
	 * Enable the droppable.
	 * @return J4GUI
	 */
	public J4GUI enableDroppable(){
		droppable.droppable(key, "enable");
		return this;
	}
	
	
	/**
	 * All draggables that match the selector will be accepted.
	 * @param String CSS selector
	 * @return J4GUI
 	 */
	public J4GUI droppableAccept(String selector){
		droppable.setDroppableOption(key, "accept", selector);
		return this;
	}
	
	
	
	public String getDroppableAccept(){
		return droppable.getDroppableOptionAsString(key, "accept");
	}
	
	
	
	/**
	 * If specified, the class will be added to the droppable while <br> 
	 * an acceptable draggable is being dragged.
	 * @param className
	 * @return J4GUI
	 */
	public J4GUI droppableActiveClass(String className){
		droppable.setDroppableOption(key, "activeClass", className);
		return this;
	}
	
	
	public String getDroppableActiveClass(){
		return droppable.getDroppableOptionAsString(key, "activeClass");
	}
	
	
	
	/**
	 * If set to false, will prevent the ui-droppable class from being added.<br>
	 * This may be desired as a performance optimization when calling .droppable() <br>
	 * init on many hundreds of elements.
	 * 
	 * @param addclass
	 * @return J4GUI
	 */
	public J4GUI droppableAddClasses(boolean addclass){
		droppable.setDroppableOption(key, "addClasses", addclass);
		return this;
	}
	
	
	public boolean getDroppableAddClasses(){
		return droppable.getDroppableOptionAsBoolean(key, "addClasses");
	}
	
	
	
	/**
	 * If true, will prevent event propagation on nested droppables.
	 * @param greedy
	 * @return J4GUI
	 */
	public J4GUI droppableGreedy(boolean greedy){
		droppable.setDroppableOption(key, "greedy", greedy);
		return this;
	}
	
	
	public boolean getDroppableGreedy(){
		return droppable.getDroppableOptionAsBoolean(key, "greedy");
	}
	
	
	
	/**
	 * If specified, the class will be added to the droppable while an acceptable <br>
	 * draggable is being hovered.
	 * @param className
	 * @return
	 */
	public J4GUI droppableHoverClass(String className){
		droppable.setDroppableOption(key, "hoverClass", className);
		return this;
	}
	
	
	public String getDroppableHoverClass(){
		return droppable.getDroppableOptionAsString(key, "hoverClass");
	}
	
	/**
	 * Used to group sets of draggable and droppable items, <br>
	 * in addition to droppable's accept option. <br> 
	 * A draggable with the same scope value as a droppable will be accepted. <br>
	 * 
	 * 
	 * @param scopeName
	 * @return J4GUI
	 */
	public J4GUI droppableScope(String scopeName){
		droppable.setDroppableOption(key, "scope", scopeName);
		return this;
	}
	
	
	public String getDroppableScope(){
		return droppable.getDroppableOptionAsString(key, "scope");
	}
	
	/**
	 * Specifies which mode to use for testing whether a draggable is 'over' a droppable. 
	 * 
	 * <b>fit:</b> draggable overlaps the droppable entirely <br>
	 * <b>intersect:</b> draggable overlaps the droppable at least 50% <br>
	 * <b>pointer:</b> mouse pointer overlaps the droppable <br>
	 * <b>touch:</b> draggable overlaps the droppable any amount <br>
	 * 
	 * @param mode
	 * @return J4GUI
	 */
	public J4GUI droppableTolerance(ToleranceMode mode){
		droppable.setDroppableOption(key, "tolerance", mode.getValue());
		return this;
	}
	
	
	public ToleranceMode getDroppableTolerace(){
		return ToleranceMode.valueOf(droppable.getDroppableOptionAsString(key, "tolerance"));
	}
	
	///////////////////////////////////////////////////////////////////////////////
	
	
	public class CursorAt {
		
		private int top;
		private int left;
		private int right;
		private int bottom;

		public CursorAt(int top,int left,int right,int bottom){
			this.top 		= top;
			this.left 		= left;
			this.right 		= right;
			this.bottom 	= bottom;
		}
		
		
		public int getTop() {
			return top;
		}
		
		public void setTop(int top) {
			this.top = top;
		}
		
		public int getLeft() {
			return left;
		}
		
		public void setLeft(int left) {
			this.left = left;
		}
		
		public int getRight() {
			return right;
		}
		
		public void setRight(int right) {
			this.right = right;
		}
		
		public int getBottom() {
			return bottom;
		}
		
		public void setBottom(int bottom) {
			this.bottom = bottom;
		}
		
		public JSONObject getJSON(){
			
			JSONObject json = new JSONObject();
			
			JSONValue top 		= JSONParser.parse(String.valueOf(this.getTop()));
			JSONValue left 		= JSONParser.parse(String.valueOf(this.getLeft()));
			JSONValue right 	= JSONParser.parse(String.valueOf(this.getRight()));
			JSONValue bottom 	= JSONParser.parse(String.valueOf(this.getBottom()));
			
			
			json.put("top", top);
			json.put("left", left);
			json.put("right", right);
			json.put("bottom", bottom);
			
			
			
			return json;
			
		}
		
	}
	
	//////////////
	// Containment Zone Class
	///////////////////////////////
	
	public class ContainmentZone {

		private int x1;
		private int y1;
		private int x2;
		private int y2;
		
		public ContainmentZone(int x1,int y1,int x2,int y2 ){
		
			this.x1 = x1;
			this.x2 = x2;
			this.y1 = y1;
			this.y2 = y2;
		
		}
		
		public int getX1() {
			return x1;
		}
		
		public int getY1() {
			return y1;
		}
		
		public int getX2() {
			return x2;
		}
		
		public int getY2() {
			return y2;
		}
		
			

	}
	
	
	public enum AnimateDuration {
		Slow("slow"), Normal("normal"),Fast("fast");
		
		private String value;
		
		private AnimateDuration(String type){
			this.value = type;
		}
		
		public String getValue() {
			return value;
		}
		
	}
	
	public enum RevertType {
		Valid("valid"), Invalid("invalid");
		
		private String value;
		
		private RevertType(String type){
			this.value = type;
		}
		
		public String getValue() {
			return value;
		}
		
	}	
	
	
	public enum SnapMode {
		Inner("inner"), Outer("outer"), Both("both");
		
		private String value;
		
		private SnapMode(String type){
			this.value = type;
		}
		
		public String getValue() {
			return value;
		}
		
	}
	
	
	
	
	public enum HelperType {
		Original("original"), Clone("clone");
		
		private String value;
		
		private HelperType(String type){
			this.value = type;
		}
		
		public String getValue() {
			return value;
		}
		
	}
	
	//////////////
	// Containment Zone Type
	///////////////////////////////	
	
	public enum ContainmentZoneType{
		Parent("parent"),Document("document"),Window("window");
		
		private String value;
		
		private ContainmentZoneType(String type){
			this.value = type;
		}
		
		public String getValue() {
			return value;
		}
		
	}
	
	
	//////////////
	// TOLERANCE ENUM
	///////////////////////////////
	
	public enum ToleranceMode {
	
	Fit("fit"), Intersect("intersect"), Pointer("pointer"), Touch("touch");	
		
		private String value;
		
		private ToleranceMode(String mode){
			this.value = mode;
		}
		
		public String getValue() {
			return value;
		}
		
	}

	
	
	//////////////
	// AXIS
	///////////////////////////////
	
	public enum AxisType {
	
	X("x"), Y("y");	
		
		private String value;
		
		private AxisType(String axis){
			this.value = axis;
		}
		
		public String getValue() {
			return value;
		}
		
	}	
	
	
}
