/**
 * Jquery-UI - A GWT library implementation of the Javascript library Jquery-ui - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.gwt.jquery.client;


import com.ebmwebsourcing.gwt.jquery.client.core.JqueryUI;
import com.ebmwebsourcing.gwt.jquery.client.ui.handler.DragHandler;
import com.ebmwebsourcing.gwt.jquery.client.ui.handler.adapter.DragHandlerAdapter;
import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.j4g.client.api.F;
import com.j4g.client.core.Jquery4Gwt;


/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class JqueryUIClient implements EntryPoint {

  /**
   * This is the entry point method.
   */
  public void onModuleLoad() { 
     
	  RootPanel.get().add(new Label ("GWT-Maven Archetype Project - mu.fleury.jquery.jquery-ui"));
     
     RootPanel root = RootPanel.get();
     
     
     final Label info = new Label();
     info.getElement().setId("info");
     root.add(info);
     
     AbsolutePanel ap = new AbsolutePanel();
     
     ap.setPixelSize(10, 10);
     
     ap.getElement().setId("toto");
     
     
     
     
     final JqueryUI j = new JqueryUI();

     root.add(ap);
     
     j.$("#toto").css("border", "1px solid black");
     j.$("#toto").bind("click", new F(){

		public void f(Event event) {
			

			
		}
    	 
     });
     
     
     
     //jQueryUI
     //j.$("#toto").draggable();


     
     j.$("#toto").draggable(new DragHandlerAdapter(){
    	 @Override
    	public F start() {
    		 
    		F f =  new F(){
    			public void f(Event event) {
    				
    	
    				//GWT.log("drag Start:"+ event.getTarget().getId(),null);
    				info.setText("drag start:"+event.getTarget().getId());
    				
    			}
    		};
    		 
    		 return f;
    		
    	}
    	 
    	 
    	@Override
    	public F stop() {
    	
    		F f =  new F(){
    			public void f(Event event) {
    				
    
    				info.setText("drag stop");
    				
    			}
    		};
    		 
    		 return f;
    		
    		
    	}
    	
    	
    	
    	@Override
    	public F drag() {
    	
    		F f =  new F(){
    			public void f(Event event) {
    				

    				info.setText("top:"+event.getTarget().getAbsoluteTop()+" left:"+event.getTarget().getAbsoluteLeft());
    				
    			}
    		};
    		 
    		 return f;
    		
    	}
    	
    	 
    	 
     });
     
     
     //j.$("#toto").resizable();
     
     
  }
}
