/**
 * diagram-interchange - Diagram Interchange Domain - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.impl;

import java.util.LinkedHashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.diagramcommon.layout.IPoint;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IEdge;


public abstract class Edge extends DiagramElement implements IEdge{
	
	private IDiagramElement source;
	private IDiagramElement target;
	
	private LinkedHashSet<IPoint> wayPoints;
	
	public Edge() {
		super();
		this.wayPoints = new LinkedHashSet<IPoint>();
	}
	
	public void setSource(IDiagramElement source){
		this.source = source;
		if (source!=null) source.addOutgoingEdge(this);
	}
	
	public void setTarget(IDiagramElement target){
		this.target = target;
		if (target!=null) target.addIncomingEdge(this);
	}
	
	@Override
	public IDiagramElement getSource() {
		return source;
	}

	@Override
	public IDiagramElement getTarget() {
		return target;
	}

	@Override
	public LinkedHashSet<IPoint> getWayPoints() {
		return wayPoints;
	}
	
	public void setWayPoints(LinkedHashSet<IPoint> points) {
		wayPoints = points;
	}
	
	public void addWayPoint(IPoint point){
		this.wayPoints.add(point);
	}
	
	@Override
	public void removeWayPoint(IPoint point) {
		this.wayPoints.remove(point);
	}
	
	@Override
	public void clearWayPoints() {
		this.wayPoints.clear();
	}

}
