/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.modeleditor.events;

import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.events.IEditorViewHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.events.ISelectedModelsChangeEvent;
import com.google.gwt.event.shared.GwtEvent;

public class SelectedModelsChangeEvent extends GwtEvent<IEditorViewHandler> implements ISelectedModelsChangeEvent{
	
	private List<IEditorModel> newSelectedModels;
	
	public static Type<IEditorViewHandler> TYPE = new Type<IEditorViewHandler>();
	
	public SelectedModelsChangeEvent(List<IEditorModel> newSelectedModels) {
		this.newSelectedModels = newSelectedModels;
	}
	
	@Override
	protected void dispatch(IEditorViewHandler handler) {
		handler.onSelectedModelsChange(this);
	}

	@Override
	public com.google.gwt.event.shared.GwtEvent.Type<IEditorViewHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	public List<IEditorModel> getNewSelectedModels() {
		return newSelectedModels;
	}

}
