/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic.events.DiagramElementViewUpdateEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic.events.DiagramViewUpdateEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IPositionChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.ISizeChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.IObservableProxy;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IMethodCalledEvent;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.IObservableHandler;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.event.ISetterCalledEvent;

/**
 * Listen to model or graphic state update
 * @author nfleury
 *
 */
public class DiagramViewListener {
	
	private DiagramController controller;
	
	public DiagramViewListener(DiagramController controller) {
		this.controller = controller;
	}
	
	@SuppressWarnings("unchecked")
	public void listen(final IDiagramView diagramView){
		
		//listen to any modification in diagramView editor model
		
		IEditorModel diagramEditorModel = diagramView.getEditorModel();
		
		final IObservableProxy observableProxy = (IObservableProxy) diagramEditorModel;
		
		observableProxy.addHandler(new IObservableHandler() {
			
			@Override
			public void onSetterCalled(ISetterCalledEvent event) {
			
				diagramView.fireEvent(new DiagramViewUpdateEvent());
				
			}
			
			@Override
			public void onMethodCalled(IMethodCalledEvent event) {
			
				
			}
		});

		
		//when adding an element => notify that diagram view as been updated
		diagramView.addUIPanelHandler(new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(
					IUnselectedElementsEvent unselectedElementsEvent) {
				
				
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
				
				
			}
			
			@Override
			public void onResizeRequest(IResizeRequestEvent event) {
				
				
			}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
				
				diagramView.fireEvent(new DiagramViewUpdateEvent());
				
			}
			
			@Override
			public void onNewUIElement(INewUIElementEvent newElementEvent) {
				
				diagramView.fireEvent(new DiagramViewUpdateEvent());
				
				//add bounds handler and listen to new element editor model
				final IDiagramElementView newEl = (IDiagramElementView) newElementEvent.getNewElement();
				
				IEditorModel newElEditorModel = newEl.getEditorModel();
				
				newEl.addBoundUpdateHandler(new IBoundsUpdateHandler() {
					
					@Override
					public void onSizeChange(ISizeChangeEvent event) {
						
						diagramView.fireEvent(new DiagramElementViewUpdateEvent(newEl));
						
					}
					
					@Override
					public void onPositionChange(IPositionChangeEvent event) {
						
						diagramView.fireEvent(new DiagramElementViewUpdateEvent(newEl));
						
					}
				});
				
				observableProxy.addHandler(new IObservableHandler() {
					
					@Override
					public void onSetterCalled(ISetterCalledEvent event) {
						
						diagramView.fireEvent(new DiagramElementViewUpdateEvent(newEl));
						
					}
					
					@Override
					public void onMethodCalled(IMethodCalledEvent event) {
					
						
					}
				});

				
				
			}
		});
		
		
	}
	
}
