/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.impl.validation;

import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;

public class RuleNotificationViewElement extends Composite implements HasClickHandlers{

	private HorizontalPanel hp;
	
	private Label elementType;
	private Label elementName;
	private Label quickFixAvailable;
	private Label quickFixDescription;
	private Label ruleDescription;
	private Image ruleLevelImg; 
	
	private IConformityRule rule;
	private RuleNotificationView view;
	
	
	public RuleNotificationViewElement(RuleNotificationView view,IConformityRule rule) {
		
		this.rule = rule;
		
		this.view = view;
		
		this.hp = new HorizontalPanel();
		this.hp.setSpacing(10);
		this.ruleLevelImg 			= this.getRuleLevelImg();
		this.ruleDescription  		= new Label(rule.getRuleDescription());
//		if (rule instanceof IDiagramElementViewConformityRule) this.elementName 			= new Label(((IDiagramElementViewConformityRule)rule).getNonConformElement().getEditorModel().getName());
		if (rule instanceof IDiagramElementViewConformityRule) this.elementType 			= new Label(((IDiagramElementViewConformityRule)rule).getNonConformElement().getName()+": ");
		

		this.quickFixAvailable 		= new Label(""+rule.canResolveNonConformity());
		this.quickFixDescription 	= new Label(rule.getResolveConformityDescription());
		
		
		this.hp.add(ruleLevelImg);
		if (rule instanceof IDiagramElementViewConformityRule) this.hp.add(elementType);
//		if (rule instanceof IDiagramElementViewConformityRule) this.hp.add(elementName);
		this.hp.add(ruleDescription);
		//this.hp.add(quickFixAvailable);
		
		
		initWidget(hp);
	}
	
	private Image getRuleLevelImg(){
		
		if (rule.getRuleLevel()==RuleLevel.ERROR){
			return new Image(GWT.getModuleBaseURL()+"/images/icons/cross_octagon.png");
		}else{
			return new Image(GWT.getModuleBaseURL()+"images/icons/exclamation_octagon_fram.png");
		}
		
		
	}

	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}
	
	
}
