/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.ebmwebsourcing.geasytools.diagrameditor.api.events.builder.IBuildDiagramInterchangeCompleteEvent;
import com.ebmwebsourcing.geasytools.diagrameditor.api.events.builder.IModelBuilderHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.diagramcommon.layout.IPoint;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.diagramcommon.layout.Point;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagram;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IEdge;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IShape;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnector;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorEnd;
import com.ebmwebsourcing.geasytools.geasyui.api.connectable.IConnectorPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IAddUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IBoundsUpdateHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IContainerHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IPositionChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.core.events.ISizeChangeEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.INewUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IRemoveUIElementEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IResizeRequestEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.ISelectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUIPanelHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.events.IUnselectedElementsEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.UIPanelVisitor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IWatchedModelProxy;
import com.google.gwt.user.client.Window;



/**
 * Builds a Diagram Object based on user interactions only.
 * Adds default handlers to DiagramUI to build a default Diagram Interchange.
 * 
 * @author nfleury
 *
 */
public class DiagramInterchangeModelBuilder {
	
	private IDiagramView diagramView;
	private DiagramController diagramController;
	
//	private UndoRedoSession undoRedoSession;
	
	protected IUIPanelHandler panelHandler;
	
	private HashMap<IEdge, List<IPoint>> edgeWayPoints;
	
	public DiagramInterchangeModelBuilder(IDiagramView diagram, DiagramController diagramController) {
		
		this.edgeWayPoints = new HashMap<IEdge, List<IPoint>>();
		
		this.diagramView = diagram;
		this.diagramController = diagramController;
		
//		this.undoRedoSession = new UndoRedoSession();
		
		//initialize diagrams models
		this.initialize();
//		
		addListeners();
	
	}
	
	
	public IDiagramView getDiagram() {
		return diagramView;
	}
	
	public IDiagram getDiagramInterchangeModel(){		
		return diagramView.getDiagram();
	}
	
	public void initialize(){
		
	


		
		
//		this.undoRedoSession.registerModel(diModel);
		
	}
	
	
	public void addListeners(){
		


		
		
		this.panelHandler = new IUIPanelHandler() {
			
			@Override
			public void onUnSelectUIElement(IUnselectedElementsEvent unselectedElementsEvent) {
				
				
				
			}
			
			@Override
			public void onSelectUIElement(ISelectedElementsEvent selectedElementsEvent) {
				
				
			}
			
			
			@Override
			public void onNewUIElement(INewUIElementEvent addElementEvent) {
				

				//1- When adding an element we 
				//a- add it to diagrams model plane
				//b- register the editors model to actual undoredosession
				//c- assign model element to diagramElement
				if (addElementEvent.getNewElement() instanceof IDiagramElementView){
					
					
					final IDiagramElementView newDiView = (IDiagramElementView) addElementEvent.getNewElement();
					
					IDiagramElement diElement = newDiView.getDiagramElement();

					
					//a - add diagram element to plane only if parent is NULL;
					if (diElement.getOwningElement()==null) getDiagramInterchangeModel().addDiagramElement(diElement);
					

					//notify Di load
//					diView.fireEvent(new DILoadEvent(diElement));					


					//b - register editor model to undoredosession
					//undoRedoSession.registerModel(diElement);					
					
					//c- assign model element to diagramElement
					IWatchedModelProxy<? extends IModelElement> proxy = (IWatchedModelProxy<? extends IModelElement>) newDiView.getEditorModel();
					diElement.setModelElement(proxy.getBindedModel());
					
					//2- If actual diagram element is a container add 
					//receive di into di container
					if (newDiView instanceof IContainer){
						
						IContainer container = (IContainer) newDiView;
						
					
						container.addContainerHandler(new IContainerHandler() {
							
							@Override
							public void onRemoveUIElement(
									com.ebmwebsourcing.geasytools.geasyui.api.core.events.IRemoveUIElementEvent event) {
								

								if (event.getUIElement() instanceof IDiagramElementView){
									
									IDiagramElementView removedElement = (IDiagramElementView) event.getUIElement() ;
									
									newDiView.getDiagramElement().removeDiagramElement(removedElement.getDiagramElement());
									
									//bind syntax model on graphical state
									//diView.getSyntaxModelBinder().bindSyntaxModelWithDI(diView.getDiagramElement().getModelElement(), diView.getDiagramElement());

									
									
								}
								
							}
							
							@Override
							public void onAddUIElement(IAddUIElementEvent event) {
								
								if (event.getUIElement() instanceof IDiagramElementView){
									
									IDiagramElementView addedElement = (IDiagramElementView) event.getUIElement() ;
									
									newDiView.getDiagramElement().addDiagramElement(addedElement.getDiagramElement());
								
									//bind syntax model on graphical state
									//diView.getSyntaxModelBinder().bindSyntaxModelWithDI(diView.getDiagramElement().getModelElement(), diView.getDiagramElement());
									
									addedElement.getDiagramElement().setOwningElement(newDiView.getDiagramElement());
								
									
								}
								
								
								
							}
						});
						
						

						
					}

					//3- Add handler on connectors so that an edge
					// is created when they are connected
//					if (newDiView instanceof IConnector){
//					
//						IConnector connector = (IConnector) newDiView;
//						
//						connector.addConnectorHandler(new ConnectorHandler() {
//							
//							private IConnectableElement connectionSource;
//							private IConnectableElement connectionTarget;
//							
//							@Override
//							public void onRemoveWayPoint(IRemoveWayPointEvent event) {
//								
////								//update edge wayPoints
////								IEdge edge = (IEdge) newDiView.getDiagramElement();
////								IConnector connector = (IConnector) newDiView;
////								
////								//remove previous waypoints from current edge
////								edge.clearWayPoints();
////								
////								Point endWayPoint = null;
////								
////								//Add new ones
////								Iterator<IConnectorPoint> it = connector.getAllConnectorPoints().iterator();
////								while (it.hasNext()){
////									
////									//end points will always be on 2 position
////									//grab it and put in in the end
////									IConnectorPoint p = it.next();
////									
////									Point wayPoint = new Point(p.getRelativeX()+p.getUIPanel().getScrollLeft()+Window.getScrollLeft(), p.getRelativeY()+p.getUIPanel().getScrollTop()+Window.getScrollTop()); 
////
////									if (p instanceof IConnectorEnd==false){										
////										edge.addWayPoint(wayPoint);										
////
////									}else{
////										endWayPoint = wayPoint;
////									}
////									
////								}
////								
////
////								
////								edge.addWayPoint(endWayPoint);
//
//							}
//							
//							@Override
//							public void onConnection(IConnectionEvent event) {
//									
//								final IEdge edge = (IEdge) newDiView.getDiagramElement();
//								
//								IConnector connector = (IConnector) newDiView;
//
//								//Start 
//								if (connectionSource==null && event.getConnectionSource()!=null){
//										
//									IDiagramElement sourceModel = ((IDiagramElementView)event.getConnectionSource()).getDiagramElement();
//									edge.setSource(sourceModel);
//
//									this.connectionSource = event.getConnectionSource();
//									
//								}else if (connectionSource!=null && event.getConnectionSource()==null){
//									edge.setSource(null);
//									this.connectionSource = null;
//								}
//								
//								//End
//								if (connectionTarget==null && event.getConnectionTarget()!=null){
//									
//									IDiagramElement targetModel = ((IDiagramElementView)event.getConnectionTarget()).getDiagramElement();
//									edge.setTarget(targetModel);
//
//									this.connectionTarget = event.getConnectionTarget();
//									
//								}else if (connectionTarget!=null && event.getConnectionTarget()==null){
//									edge.setTarget(null);
//									this.connectionTarget = null;
//								}
//
//
//							}
//							
//							@Override
//							public void onAddWayPointRequest(IAddWayPointEvent event) {
//								
//								
//							}
//
//							@Override
//							public void onDisconnection(
//									IDisconnectionEvent event) {
//								// TODO Auto-generated method stub
//								
//							}
//
//							@Override
//							public void onRefresh(IRefreshEvent event) {
//								
////								//update edge wayPoints
////								IEdge edge = (IEdge) newDiView.getDiagramElement();
////								IConnector connector = (IConnector) newDiView;
////								
////								//remove previous waypoints from current edge
//////								edge.clearWayPoints();
////								
////								IPoint endWayPoint = null;
////								
////								//Add new ones
////								Iterator<IConnectorPoint> it = connector.getAllConnectorPoints().iterator();
////								while (it.hasNext()){
////									
////									//end points will always we on 2 position
////									//grab it and put in in the end
////									IDiagramEdgeWayPoint p = (IDiagramEdgeWayPoint) it.next();
////									
////									//Point wayPoint = new Point(p.getRelativeX()+p.getUIPanel().getScrollLeft()+Window.getScrollLeft(), p.getRelativeY()+p.getUIPanel().getScrollTop()+Window.getScrollTop()); 
////
////									if (p instanceof IConnectorEnd==false){										
////										edge.addWayPoint(p.getPoint());										
////
////									}else{
////										endWayPoint = p.getPoint();
////									}
////									
////								}
////								
////								edge.addWayPoint(endWayPoint);
//
//							}
//
//							@Override
//							public void onAddIntermediateConnectorPoint(
//									IAddIntermediateConnectorPointEvent event) {
//
//								final IEdge edge = (IEdge) newDiView.getDiagramElement();
//
//								Helper.synchronizeConnectorPoint(event.getConnectorPoint(), edge);
//								
//								
//							}
//
//							@Override
//							public void onConnectorEndInitialization(
//									IConnectorEndInitializationEvent event) {
//								
//								final IEdge edge = (IEdge) newDiView.getDiagramElement();
//								
//								IConnectorPoint connectorPoint = event.getConnectorEnd();
//								
//								final IDiagramEdgeWayPoint wayPoint = (IDiagramEdgeWayPoint) connectorPoint;
//								
//								Point point = new Point(connectorPoint.getRelativeX()+connectorPoint.getUIPanel().getScrollLeft()+Window.getScrollLeft(), connectorPoint.getRelativeY()+connectorPoint.getUIPanel().getScrollTop()+Window.getScrollTop());
//								
//								if (wayPoint.getPoint()==null){
//									edge.addWayPoint(point);
//									wayPoint.setPoint(point);
//								}
//								
//
//							}
//
//							@Override
//							public void onConnectorStartInitialization(
//									IConnectorStartInitializationEvent event) {
//								
//								IConnectorPoint connectorPoint = event.getConnectorStart();
//								
//								IEdge edge = (IEdge) newDiView.getDiagramElement();
//								
//								final IDiagramEdgeWayPoint wayPoint = (IDiagramEdgeWayPoint) connectorPoint;
//								
//								Point point = new Point(connectorPoint.getRelativeX()+connectorPoint.getUIPanel().getScrollLeft()+Window.getScrollLeft(), connectorPoint.getRelativeY()+connectorPoint.getUIPanel().getScrollTop()+Window.getScrollTop());
//								
//								if (wayPoint.getPoint()==null){
//									edge.addWayPoint(point);
//									wayPoint.setPoint(point);
//								}
//							
//							}
//
//							@Override
//							public void onRemoveIntermediateConnectorPoint(
//									IRemoveIntermediateConnectorPointEvent event) {
//								
//								final IEdge edge = (IEdge) newDiView.getDiagramElement();
//								
//								final IDiagramEdgeWayPoint wayPoint = (IDiagramEdgeWayPoint) event.getConnectorPoint();
//								
//								edge.removeWayPoint(wayPoint.getPoint());
//							
//							}
//						});
//						
//					}
//					
					

					//4- Add bound update handlers if actual DI is a Shape
					//so that we update corresponding di bounds
					if (newDiView.getDiagramElement() instanceof IShape){

						final IShape shape  = (IShape) newDiView.getDiagramElement();
						
						newDiView.addBoundUpdateHandler(new IBoundsUpdateHandler() {
							
							@Override
							public void onSizeChange(ISizeChangeEvent event) {

								shape.getBounds().setWidth(event.getNewWidth());
								shape.getBounds().setHeight(event.getNewHeight());
								
							}
							
							@Override
							public void onPositionChange(IPositionChangeEvent event) {
								//System.out.println(diView.getName()+" position x:"+event.getNewRelativeX()+" y:"+event.getNewRelativeY());
								shape.getBounds().setX(event.getNewRelativeX());
								shape.getBounds().setY(event.getNewRelativeY());
								
							}
						});

							
					}
				
				
					

				
				}
				


				
				
			}

			@Override
			public void onResizeRequest(IResizeRequestEvent event) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onRemoveUIElement(IRemoveUIElementEvent removeElementEvent) {
					
					IDiagramElementView elView = (IDiagramElementView) removeElementEvent.getRemovedElement();
					
					
					getDiagramInterchangeModel().getRootElement().removeDiagramElement(elView.getDiagramElement());
			}
		};
 

		
		this.diagramController.addModelBuilderHandler(new IModelBuilderHandler() {
			
			@Override
			public void onBuildDiagramInterchangeComplete(
					IBuildDiagramInterchangeCompleteEvent event) {

				IDiagramView diagramView = event.getDiagramView();
				
				new UIPanelVisitor(diagramView) {
					
					@Override
					protected void visitConnector(IConnector connector) {
						
						
						//build waypoints
						
						IDiagramElementView view = (IDiagramElementView) connector;
						
						IEdge edge = (IEdge) view.getDiagramElement();
						
						//remove previous waypoints from current edge
						edge.clearWayPoints();
						
						Point endWayPoint = null;
						
						//Add new ones
						Iterator<IConnectorPoint> it = connector.getAllConnectorPoints().iterator();
						while (it.hasNext()){
							
							//end points will always be on 2 position
							//grab it and put in in the end
							IConnectorPoint p = it.next();
							
							Point wayPoint = new Point(p.getRelativeX()+p.getUIPanel().getScrollLeft()+Window.getScrollLeft(), p.getRelativeY()+p.getUIPanel().getScrollTop()+Window.getScrollTop()); 

							if (p instanceof IConnectorEnd==false){										
								edge.addWayPoint(wayPoint);										

							}else{
								endWayPoint = wayPoint;
							}
							
						}
						

						
						edge.addWayPoint(endWayPoint);
						
						
						///////Set source / target
						
						IDiagramElementView sourceView = (IDiagramElementView) connector.getSource();
						IDiagramElementView targetView = (IDiagramElementView) connector.getTarget();
						
						edge.setSource(sourceView.getDiagramElement());
						edge.setTarget(targetView.getDiagramElement());
						
					}
				};
				
			}

			
		});		
		

		diagramView.addUIPanelHandler(panelHandler);		
	}


	
}
