/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.diagrameditor.api.graphic;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.events.IDiagramViewHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.modeleditor.IHasEditorModel;
import com.ebmwebsourcing.geasytools.diagrameditor.api.syntax.ISyntaxModelBuilder;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IContextualNotification;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagram;
import com.ebmwebsourcing.geasytools.geasyui.api.palette.IHasPalette;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;

/**
 * 
 * @author nfleury
 *
 */
public interface IDiagramView extends IUIPanel,IHasPalette,IHasEditorModel{
	

	
	/**
	 * <b>Important:</b> instance of this object should be created
	 * using GWT.create() method
	 * @return
	 */
	IDiagram getDiagram();
	
	void setDiagram(IDiagram diagram);
	
	IDiagramElementViewFactory getElementFactory();

	
	void addUIElement(IDiagramElementView uiElement);
	
	IDiagramElementView getUIElementById(String id);
	
	HashSet<IDiagramViewConformityRule> getConformityRules();
	
	void addHandler(IDiagramViewHandler handler);
	
	void setContextualNotification(int x,int y, IContextualNotification notification);
	
	HashSet<IContextualNotification> getContextualNotifications();
	
	ISyntaxModelBuilder getSyntaxModelBuilder();
	
}
