/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor.impl.graphic;

import java.util.HashMap;

import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementView;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementViewInstantiationHandler;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramElementViewInstantiationHandlerRegistry;
import com.ebmwebsourcing.geasytools.diagrameditor.api.graphic.IDiagramView;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IDiagramElement;
import com.ebmwebsourcing.geasytools.diagrameditor.domain.diagramdefinition.interchange.api.IModelElement;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IHasDragProxy;

@SuppressWarnings("unchecked")
public class DiagramElementViewInstantiationHandlerRegistry implements IDiagramElementViewInstantiationHandlerRegistry{


	private HashMap<Class<? extends IDiagramElementView> , IDiagramElementViewInstantiationHandler<?>> handlersByDiagramElementViewType;
	private HashMap<Class<? extends IModelElement> , IDiagramElementViewInstantiationHandler<?>> handlersBySyntaxModelType;
	
	private static DiagramElementViewInstantiationHandlerRegistry instance;
	
	private DiagramElementViewInstantiationHandlerRegistry() {
		
		this.handlersByDiagramElementViewType 	= new HashMap<Class<? extends IDiagramElementView>, IDiagramElementViewInstantiationHandler<?>>();
		this.handlersBySyntaxModelType 			= new HashMap<Class<? extends IModelElement>, IDiagramElementViewInstantiationHandler<?>>();
		
	}
	
	
	public IDiagramElementView getElementByDiagramElementModel(
			IDiagramElement diagramElement,IDiagramView diagramView) {
		
		IDiagramElementViewInstantiationHandler<?> h = handlersBySyntaxModelType.get(diagramElement.getModelElement().getClass());
		
		if (h==null) throw new NullPointerException("No instantiation handler registered for type :"+diagramElement.getModelElement().getClass());
		
		IDiagramElementView view = h.instantiate(diagramElement,diagramView);
		
		return view;
	}



	public IUIElement getElement(IHasDragProxy draggableProxyData,IDiagramView diagramView) {
		
		IDiagramElementViewInstantiationHandler<?> h =  handlersByDiagramElementViewType.get(draggableProxyData.getIUIElementType());
		IDiagramElementView view = h.instantiate(draggableProxyData,diagramView);
		
		return view;
	}


	public IUIElement getElement(Class<? extends IUIElement> elementType,IDiagramView diagramView) {

		IDiagramElementViewInstantiationHandler<?> h =  handlersByDiagramElementViewType.get(elementType);
		IDiagramElementView view = h.createElement(null,diagramView);
		
		return view;
	}
	
	public static DiagramElementViewInstantiationHandlerRegistry getInstance(){
		
		if (instance==null){
			instance = new DiagramElementViewInstantiationHandlerRegistry();
		}
		
		return instance;
	}




	@Override
	public void registerDiagramElementViewInstantiationHandler(
			Class<? extends IDiagramElementView> elementType,
			Class<? extends IModelElement> syntaxModelType,
			IDiagramElementViewInstantiationHandler<?> handler) {

		handlersByDiagramElementViewType.put(elementType, handler);
		handlersBySyntaxModelType.put(syntaxModelType, handler);
		
	}




}
