/**
 * geasy-diagram-editor - A project for editing diagrams based on OMG Diagram Definition standard - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.diagrameditor.impl.test;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.diagrameditor.DiagramController;
import com.ebmwebsourcing.geasytools.diagrameditor.api.test.IDiagramAssert;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramElementViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.api.validation.IDiagramViewConformityRule;
import com.ebmwebsourcing.geasytools.diagrameditor.helper.designer.DiagramElementProxy;
import com.ebmwebsourcing.geasytools.diagrameditor.impl.validation.DiagramValidationException;

public class DiagramAssert implements IDiagramAssert{
	
	private DiagramController diagramController;
	
	public DiagramAssert(DiagramController controller) {
		this.diagramController = controller;
	}
	
	@Override
	public void assertValidationFails() {

		try {
			
			getDiagramController().validate();

		} catch (DiagramValidationException e) {
			
			System.out.println("Validation failed with following message:"+e.getMessage());
			
		
		}finally{
			
			if (getDiagramController().getNotificationRegistry().getRulesInFailure().size()==0){
				fail("Validation did not failed");
			}
			
		}
		
	}
	
	@Override
	public void assertValidationDoesNotFail() {
		
		try {
			
			getDiagramController().validate();

		} catch (DiagramValidationException e) {
			
			System.out.println("Validation failed with following message:"+e.getMessage());
			
		
		}finally{
			
			if (getDiagramController().getNotificationRegistry().getRulesInFailure().size()>0){
				fail("Validation failed");
			}
			
		}
		
	}
	
	
	public DiagramController getDiagramController() {
		return diagramController;
	}
	
	
	private static void fail(String message){
		
		throw new DiagramAssertionException(message);
		
	}

	@Override
	public void assertElementIsConformToRule(DiagramElementProxy<?> element,
			Class<? extends IDiagramElementViewConformityRule> ruleClazz) {
		
		
		
		
		try {
			
			getDiagramController().validate();
			
		} catch (DiagramValidationException e) {
			
			System.out.println("Validation failed with following message:"+e.getMessage());
		
		}finally {
			
			if (elementIsConformToRule(element, ruleClazz)==false){
				fail("Element "+element.getDiagramElement()+" is not conform to rule of type "+ruleClazz);
			}
			
		}
		
	}

	
	private boolean elementIsConformToRule(DiagramElementProxy<?> element,
			Class<? extends IDiagramElementViewConformityRule> ruleClazz){
		
		boolean hasInstance = false;
		
		//first ensure that element has an instance of requested rule
		for(IDiagramElementViewConformityRule rule:element.getDiagramElement().getConformityRules()){
			
			if (rule.getClass().equals(ruleClazz)){
				hasInstance = true;
				break;
			}
			
		}
		
		
		if (hasInstance==false){
			
			fail("Element "+element.getDiagramElement()+" conformity rules does not contain any instance of "+ruleClazz);
			
		}
		
		boolean ok = true;
		
		
		HashSet<IConformityRule> rules = new HashSet<IConformityRule>();
		
		rules.addAll(getDiagramController().getNotificationRegistry().getRulesInFailure());
		rules.addAll(getDiagramController().getNotificationRegistry().getRulesInWarning());
		
		for(IConformityRule rule:rules){
			
			if (rule instanceof IDiagramElementViewConformityRule){
				
				IDiagramElementViewConformityRule elementRule = (IDiagramElementViewConformityRule) rule;
				
				if (elementRule.getNonConformElement()==element.getDiagramElement() && rule.getClass().equals(ruleClazz)){
					ok = false;
					break;
				}
				
			}
			
		}
		
		
		
		
		return ok;
	}
	
	
	private boolean diagramIsConformToRule(Class<? extends IDiagramViewConformityRule> ruleClazz){
		
		boolean hasInstance = false;
		
		//first ensure that diagram has an instance of requested rule
		for(IDiagramViewConformityRule rule:diagramController.getDiagramView().getConformityRules()){
			
			if (rule.getClass().equals(ruleClazz)){
				hasInstance = true;
				break;
			}
			
		}
		
		
		if (hasInstance==false){
			
			fail("Diagram "+diagramController.getDiagramView().getName()+" conformity rules does not contain any instance of "+ruleClazz);
			
		}
		
		boolean ok = true;
		
		HashSet<IConformityRule> rules = new HashSet<IConformityRule>();
		
		rules.addAll(getDiagramController().getNotificationRegistry().getRulesInFailure());
		rules.addAll(getDiagramController().getNotificationRegistry().getRulesInWarning());
		
		for(IConformityRule rule:rules){
			
			if (rule instanceof IDiagramViewConformityRule){
				
				IDiagramViewConformityRule elementRule = (IDiagramViewConformityRule) rule;
				
				if (rule.getClass().equals(ruleClazz)){
					ok = false;
					break;
				}
				
			}
			
		}
		
		
		return ok;		
		
		
	}
	
	
	@Override
	public void assertElementIsNotConformToRule(DiagramElementProxy<?> element,
			Class<? extends IDiagramElementViewConformityRule> ruleClazz) {
		
		try {
			
			getDiagramController().validate();
			
		} catch (DiagramValidationException e) {
			
			System.out.println("Validation failed with following message:"+e.getMessage());
		
		}finally {
			
			if (elementIsConformToRule(element, ruleClazz)){
				fail("Element "+element.getDiagramElement()+" is conform to rule of type "+ruleClazz);
			}
			
		}
	
	}

	@Override
	public void assertDiagramIsConformToRule(Class<? extends IDiagramViewConformityRule> ruleClazz) {
		
		try {
			
			getDiagramController().validate();
			
		} catch (DiagramValidationException e) {
			
			System.out.println("Validation failed with following message:"+e.getMessage());
		
		}finally {
			
			if (diagramIsConformToRule(ruleClazz)==false){
				fail("Diagram "+diagramController.getDiagramView().getName()+" is not conform to rule of type "+ruleClazz);
			}
			
		}
		
	}

	@Override
	public void assertDiagramIsNotConformToRule(Class<? extends IDiagramViewConformityRule> ruleClazz) {
		
		try {
			
			getDiagramController().validate();
			
		} catch (DiagramValidationException e) {
			
			System.out.println("Validation failed with following message:"+e.getMessage());
		
		}finally {
			
			if (diagramIsConformToRule(ruleClazz)){
				fail("Diagram "+diagramController.getDiagramView().getName()+" is conform to rule of type "+ruleClazz);
			}
			
		}
		
	}

	@Override
	public void assertDiagramElementsCount(int count) {
		
		if (diagramController.getDiagramView().getUIElements().size()!=count){
			fail("Diagram elements actual count:"+diagramController.getDiagramView().getUIElements().size()+"| Expected:"+count);
		}
		
	}




	
	

}
