/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IMarker;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IPath;
import com.google.gwt.user.client.Element;

public class Path extends SVGElement implements IPath {
	
	private String path;
	private IMarker markerStart;
	private IMarker markerMid;
	private IMarker markerEnd;
	
	
	public Path(Element element,String path, float x, float y) {
		super(element, x, y);
		this.path = path;
	}



	@Override
	public String getPath() {
		return path;
	}



	@Override
	public IMarker getMarkerEnd() {
		return this.markerEnd;
	}



	@Override
	public IMarker getMarkerMid() {
		return this.markerMid;
	}



	@Override
	public IMarker getMarkerStart() {
		return this.markerStart;
	}



	@Override
	public void setMarkerEnd(IMarker marker) {
		((IPath)this.impl).setMarkerEnd(marker);
		this.markerEnd  = marker;
	}



	@Override
	public void setMarkerMid(IMarker marker) {
		((IPath)this.impl).setMarkerMid(marker);
		this.markerMid = marker;
	}



	@Override
	public void setMarkerStart(IMarker marker) {
		((IPath)this.impl).setMarkerStart(marker);
		this.markerStart = marker;
	}



	@Override
	public void setPath(String path) {
		((IPath)this.impl).setPath(path);
		this.path = path;
	}

	
	@Override
	public float getWidth() {
		return ((IPath)this.impl).getWidth();
	}
	
	@Override
	public float getHeight() {
		return ((IPath)this.impl).getHeight();
	}
	
	@Override
	public void setX(float x) {
		float newX = x - this.getX();
		this.impl.setX(newX);
		super.setX(x);
	}
	
	@Override
	public void setY(float y) {
		float newY = y- this.getY();
		this.impl.setY(newY);
		super.setY(y);
	}
	
}
