/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IRectangle;
import com.google.gwt.user.client.Element;

public class Rectangle extends SVGElement implements IRectangle {

	private double roundedCornerRadius;
	
	public Rectangle(Element element, float x, float y,float width, float height) {
		super(element, x,y);

	}

	public Rectangle(Element element, float x, float y,float width, float height,double roundedCornerRadius) {
		super(element, x,y);
		
		this.roundedCornerRadius = roundedCornerRadius;
		
	}
	
	@Override
	public void setX(float x) {
		this.impl.setX(x);
		super.setX(x);
	}
	
	@Override
	public void setY(float y) {
		this.impl.setY(y);
		super.setY(y);
	}

	@Override
	public void setRoundedCornersRadius(double radius) {
		((IRectangle)this.impl).setRoundedCornersRadius(radius);
		this.roundedCornerRadius = radius;
	}

	@Override
	public double getRoundedCornesRadius() {
		return roundedCornerRadius;
	}

}
