/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IMarker;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;

public class MarkerJSNI extends SVGElementJSNI implements IMarker{

	
	protected native Element createMarkerJS(JavaScriptObject raphaelPaper,String id)/*-{
	
		var marker = raphaelPaper.marker(id);
		
		this.@com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.MarkerJSNI::setSvgElementJsObject(Lcom/google/gwt/core/client/JavaScriptObject;)(marker);
		
		return marker.node;

	}-*/;
	
	
	
	/**
	 * Getters
	 */
	
	@Override
	public double getRefX() {return 0;}

	@Override
	public double getRefY() {return 0;}

	@Override
	public HashSet<ISVGElement> getChildren() {return null;}

	@Override
	public ISVGElement getElementById(String id) {return null;}



	/**
	 * Setters
	 */

	
	@Override
	public void removeChild(ISVGElement svgElement) {
		
		SVGElement svgEl = (SVGElement) svgElement;
		
		this.removeChildJS(getSvgElementJsObject(), ((SVGElementJSNI)svgEl.getImpl()).getSvgElementJsObject());
		
	}

	
	
	@Override
	public void setRefX(double x) {
		
		setRefXJS(getSvgElementJsObject(), x);
	
	}

	@Override
	public void setRefY(double y) {
		
		setRefYJS(getSvgElementJsObject(), y);
		
	}

	@Override
	public void appendChild(ISVGElement svgElement) {
	
		SVGElement svgEl = (SVGElement) svgElement;
		
		this.appendChildJS(this.getSvgElementJsObject(),((SVGElementJSNI)svgEl.getImpl()).getSvgElementJsObject());
		
	}

	@Override
	public void setHeight(float height) {
		
		setHeightJS(getSvgElementJsObject(), height);
		
	}

	@Override
	public void setWidth(float width) {
		
		setWidthJS(getSvgElementJsObject(), width);
		
	}
	
	@Override
	public void setOrient(String orient) {
		
		setOrientJS(getSvgElementJsObject(),orient);
		
	}
	




	/**
	 * JSNI IMPL
	 */

	private native void setOrientJS(JavaScriptObject svgElementJs, String orient)/*-{
	
		svgElementJs.orient(orient);
	
	}-*/;
	
	
	public native void removeChildJS(JavaScriptObject svgElementJS,JavaScriptObject child)/*-{
	
		svgElementJS.remove(child);
	
	}-*/;
	

	public native void setRefXJS(JavaScriptObject svgElement,double x)/*-{
	
		svgElement.refX(x);
	
	}-*/;


	public native void setRefYJS(JavaScriptObject svgElement,double y)/*-{

		svgElement.refY(y);
	
	}-*/;


	public native void appendChildJS(JavaScriptObject jsObj,JavaScriptObject  child)/*-{
	
		jsObj.append(child);
	
	}-*/;


	public native void setHeightJS(JavaScriptObject svgElement,float height)/*-{
	
		svgElement.markerHeight(height);
	
	}-*/;


	public native void setWidthJS(JavaScriptObject svgElement,float width)/*-{
	
		svgElement.markerWidth(width);
	
	}-*/;



	@Override
	public int getAbsoluteLeft() {
		// TODO Auto-generated method stub
		return 0;
	}



	@Override
	public int getAbsoluteTop() {
		// TODO Auto-generated method stub
		return 0;
	}




	
}
