/*************************************************************************
 * Raphael 1.5.2 JS extension for com.ebmwebsourcing.geasytools.geasysvg
 * Extends Raphael by adding more elements that are not implemented:
 * 
 * => Group, Marker
 * 
 * @author nfleury
 * 
 * TODO: IE VML implementation
 *************************************************************************/


/**
 * As Raphael doesn't directly manipulates DOM element (but Raphael objects)
 * we must create a Raphael Object to inherit of Raphael functionalities.
 * 
 * The thing is that Raphael doesn't expose any Raphael object class, so the 
 * trick is to clone a simple object contained in Raphael.el
 * 
 * The following clone() method helps to deal with that.
 */

if (window.Raphael){

function clone(obj){

    var temp = new Object(); 

    for(var key in obj)
        temp[key] = obj[key];
        
      temp.constructor();  
    return temp;
}



/******************************
 * Group Element extension
 * http://www.w3.org/TR/SVG/struct.html#GElement
 *****************************/
Raphael.fn.group = function(){

	obj = clone(Raphael.el);
	
	obj.node = this.canvas.ownerDocument.createElementNS(this.canvas.namespaceURI,"g");

	this.canvas.appendChild(obj.node);
	
	obj.id 		= Raphael._oid;
	obj.type	= "group";
	obj.paper	= this;
	
	//obj to save transformation state
	obj.currentTransform = {
			
			translate : "",
			rotate:"",
			scale:"",
			
			getAttribute: function(){
				
				return this.translate + " " + this.rotate + " " + this.scale; 
		
			}
			
	};
	
	
	//specific method extension we dont use Raphael.el here to add this method because 
	//all child would inherit that stuff ...
	obj.append = function (raphaelObject){
		this.node.appendChild(raphaelObject.node);		
	}
	
	obj.remove = function (){
		this.node.parentNode.removeChild(this.node);
	}	
	
	obj.translate = function(tx,ty){
		
		this.currentTransform.translate = "translate("+tx+","+ty+")";
		
		this.node.setAttribute("transform",this.currentTransform.getAttribute());
	};
	
	obj.rotate = function(cx){
		
		
		this.currentTransform.rotate = "rotate("+cx+")";

		
		this.node.setAttribute("transform",this.currentTransform.getAttribute());
	};
	
	obj.scale = function(sx,sy){
		
		this.currentTransform.scale = "scale("+sx+", "+sy+")";
		
		this.node.setAttribute("transform",this.currentTransform.getAttribute());
	};
	
	obj.pointerEvents = function(pointerEvents){
		this.node.setAttribute("pointer-events",pointerEvents);
	};

	return obj;			
	
}



/******************************
 * Marker Element extension
 * http://www.w3.org/TR/SVG/painting.html#MarkerElement
 *****************************/
Raphael.fn.marker = function(id){
	
	if (id==null){
		throw "Id must be provided for markers";
	}	
	
	obj = clone(Raphael.el);
	
	obj.node = this.canvas.ownerDocument.createElementNS(this.canvas.namespaceURI,"marker");
	
	obj.node.id = id;
	
	this.defs.appendChild(obj.node);
	
	obj.id 		= Raphael._oid;
	obj.type	= "marker";
	obj.paper	= this;
	
	
	//specific method extension we dont use Raphael.el here to add this method because 
	//all child would inherit that stuff ...
	obj.append = function (raphaelObject){
		this.node.appendChild(raphaelObject.node);		
	}
	
	obj.remove = function (raphaelObject){
		this.node.removeChild(raphaelObject.node);
	}	
	
	obj.markerHeight = function(height){
		this.node.setAttribute("markerHeight",height);
	}	

	obj.markerWidth = function(width){
		this.node.setAttribute("markerWidth",width);
	}
	
	obj.refX = function(x){
		this.node.setAttribute("refX",x);
	}
	
	obj.refY = function(y){
		this.node.setAttribute("refY",y);
	}
	
	obj.orient = function(orient){
		this.node.setAttribute("orient",orient);
	}
	

	
	
	return obj;				
}


/******************************
 * Add some utility function to change some properties on the SVGDocument
 * SVGDocument::desc
 * SVGDocument::title
 * SVGDocument::appendChild
 *****************************/
Raphael.fn.description = function(desc){
	
	this.canvas.desc.innerText = desc;
	
}

Raphael.fn.title = function(title){
	
	this.canvas.setAttribute("title",title);

}

Raphael.fn.appendChild = function(child){

	this.canvas.appendChild(child.node);	

}	

/******************************
 * Path extension
 * http://www.w3.org/TR/SVG/painting.html#MarkerProperties
 * Allow to add markers properties on path  
 *****************************/

Raphael.el.markerStart = function(markerId){
	
	if (this.type=="path"){
	
		this.node.setAttribute("marker-start","url(#"+markerId+")");

	}else{
		throw "method markerStart can only be applied on Path element";
	}	
		
}

Raphael.el.markerMid = function(markerId){
	
	if (this.type=="path"){
		
		this.node.setAttribute("marker-mid","url(#"+markerId+")");
		
	}else{
		throw "method markerMid can only be applied on Path element";
	}	
	
}

Raphael.el.markerEnd = function(markerId){
	
	if (this.type=="path"){
		
		this.node.setAttribute("marker-end","url(#"+markerId+")");
		
	}else{
		throw "method markerEnd can only be applied on Path element";
	}	
	
}

}