/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.api;



public interface ISVGElement   {

	
	void setId(String id);
	
	String getId();
	
	IContainer getContainer();
	
	void setContainer(IContainer container);
	
	float getY();
	
	float getX();
	
	void setX(float x);
	
	void setY(float y);
	
	boolean isVisible();
	
	void setCanvas(ISVGDocument canvas);
	
	ISVGDocument getCanvas();
	
	void setVisible(boolean visible);
	
	/**
	 * Rotates the element by the given degree from its center point. 
	 * 
	 * @param int degree Degree of rotation (0 – 360°)
	 * @param boolean isAbsolute [optional] Specifies is degree is relative to <br> previous position (false) or is it absolute angle (true)
	 */
	void rotate(float degree, boolean isAbsolute);

	/**
	 * Rotates the element by the given degree from its center point. 
	 * 
	 * @param int degree Degree of rotation (0 – 360°)
	 * @param int cx [optional] X coordinate of the origin of rotation
	 * @param int cy [optional] Y coordinate of the origin of rotation
	 */
	void rotate(float degree, int cx, int cy);

	/**
	 * Moves the element around the canvas by the given distances.
	 * 
	 * @param int dx Pixels of translation by X axis
	 * @param int dy Pixels of translation by Y axis
	 */
	void translate(float dx,float dy);

	/**
	 * Resizes the element by the given multiplier.
	 * 
	 * @param float xTimes
	 * @param float yTimes
	 */
	void scale(float xTimes,float yTimes);

	/**
	 * Resizes the element by the given multiplier.
	 * 
	 * @param float xTimes
	 * @param float yTimes
	 * @param float centerX
	 * @param float centerY
	 */
	void scale(float xTimes,float yTimes,float centerX,float centerY);
	

	void toFront();
	
	
	void toBack();
	
	void remove();
	
	void setStokeColour(String colour);
	
	String getStrokeColour();
	
	void setFillOpacity(float fillOpacity);
	
	float getFillOpacity();
	
	void setStrokeDashArray(String strokeDash);
	
	String getStrokeDashArray();
	
	void setFillColour(String colour);
	
	String getFillColour();
	
	/**
	 * Returns elements with based on BBox.width
	 * @return float Element Width
	 */
	float getWidth();
	
	
	/**
	 * Returns elements with based on BBox.height
	 * @return float Element Height
	 */
	float getHeight();
	
	void setWidth(float width);
	
	void setHeight(float height);

	

}