/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl;


import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.ext.impl.LinearPath;
import com.google.gwt.event.logical.shared.HasResizeHandlers;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.SimplePanel;

public class Canvas extends SimplePanel implements HasResizeHandlers {

	
	private SVGDocument svgDoc;
	
	
	public Canvas(int width,int height) {
		
		this.svgDoc = new SVGDocument(this, width, height);
		
		this.setPixelSize(width, height);
		
	
	}
	
	public void setWidth(int width){
		this.svgDoc.setWidth(width);
	}
	
	public void setHeight(int height){
		this.svgDoc.setHeight(height);
	}
	
	public int getWidth(){
		return (int) svgDoc.getWidth();
	}
	
	public int getHeight(){
		return (int) svgDoc.getHeight();
	}
	
	
	public void appendChild(ISVGElement svgElement){
		this.svgDoc.appendChild(svgElement);
	}

	
	public Circle createCircle(float cx,float cy,float radius){
		return (Circle) this.svgDoc.createCircle(cx, cy, radius);
	}
	
	public Group createGroup(){
		return (Group) this.svgDoc.createGroup();
	}
	
	public Group createGroup(float x,float y){
		return (Group) this.svgDoc.createGroup(x,y);
	}
	
	public Path createPath(String path,float x, float y){
		return (Path) this.svgDoc.createPath(path,x,y);
	}
	
	public Rectangle createRectangle(float rx,float ry,float width,float height){
		return (Rectangle) this.svgDoc.createRectangle(rx, ry, width, height);
	}
	
	public Rectangle createRectangle(float rx,float ry,float width,float height,double cornersRadius){
		return (Rectangle) this.svgDoc.createRectangle(rx, ry, width, height,cornersRadius);
	}	
	
	public Text createText(float x,float y,String text){
		return (Text) this.svgDoc.createText(x, y, text);
	}
	
	public Marker createMarker(String id){
		return (Marker) this.svgDoc.createMarker(id);
	}
	
	public LinearPath createLinearPath(float x,float y){
		return (LinearPath) this.svgDoc.createLinearPath(x, y);
	}

	@Override
	public HandlerRegistration addResizeHandler(ResizeHandler arg0) {
		return addHandler(arg0, ResizeEvent.getType());
	}


	
}
