/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.IRectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;

public class RectangleJSNI extends SVGElementJSNI implements IRectangle{

	@Override
	public double getRoundedCornesRadius() {
		return 0;
	}

	@Override
	public void setRoundedCornersRadius(double radius) {
		
		this.setRoundedCornersRadiusJS(getSvgElementJsObject(),radius);
		
	}



	@Override
	public void setX(float x) {
		
		this.setXJS(getSvgElementJsObject(),x);
		
	}
	
	@Override
	public void setY(float y) {
		
		this.setYJS(getSvgElementJsObject(),y);
		
	}

	
	///////////::JSNI
	
	
	
	protected native Element createRectangleJS(JavaScriptObject raphaelPaper, float rx, float ry, float width, float height)/*-{
	
		var rect = raphaelPaper.rect(rx,ry,width,height);
		
		this.@com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.RectangleJSNI::setSvgElementJsObject(Lcom/google/gwt/core/client/JavaScriptObject;)(rect);
		
		return rect.node;

	}-*/;
	
	
	private native void setRoundedCornersRadiusJS(JavaScriptObject svgElement,
			double radius)/*-{
	
		svgElement.attr("r",radius);
	
	}-*/;
	
	private native void setXJS(JavaScriptObject svgElement,float x)/*-{
		
		svgElement.attr("x",x);
		
	}-*/;
	
	
	private native void setYJS(JavaScriptObject svgElement,float y)/*-{
		
		svgElement.attr("y",y);
		
	}-*/;


	

}
