/**
 * geasy-svg - A crossbrowser SVG/VML library for GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael;

import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasysvg.core.api.ICircle;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IGroup;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IMarker;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IPath;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IRectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.ISVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.api.IText;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Circle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Group;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Marker;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Path;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Rectangle;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.SVGElement;
import com.ebmwebsourcing.geasytools.geasysvg.core.impl.Text;
import com.ebmwebsourcing.geasytools.geasysvg.ext.api.ILinearPath;
import com.ebmwebsourcing.geasytools.geasysvg.ext.api.ISVGDocumentExt;
import com.ebmwebsourcing.geasytools.geasysvg.ext.impl.LinearPath;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Element;


public class SVGDocumentJSNI implements ISVGDocumentExt{
	
		
	private JavaScriptObject raphaelPaper;
	
	private float width;
	private float height;
	
	
	public native Element createCanvas(Element element,int width,int height)/*-{		
		
		var raphael = $wnd.Raphael(element,width,height); 

		this.@com.ebmwebsourcing.geasytools.geasysvg.core.impl.raphael.SVGDocumentJSNI::raphaelPaper = raphael;
		
		return raphael.canvas;
	}-*/;
	
	
	

	
	
	@Override
	public ICircle createCircle(float cx, float cy, float radius) {
		
		CircleJSNI cjsni = new CircleJSNI();
		
		Circle circle = new Circle(cjsni.createCircle(raphaelPaper, cx, cy, radius), cx, cy, radius);
		
		circle.setImpl(cjsni);
		
		return circle;
	}

	
	
	@Override
	public IGroup createGroup() {
		
		GroupJSNI gjsni = new GroupJSNI();
		
		Group group = new Group(gjsni.createGroupJS(raphaelPaper));
		
		group.setImpl(gjsni);
		
		return group;
	}

	

	@Override
	public IGroup createGroup(float x, float y) {
		return this.createGroup();
	}
	
	

	@Override
	public IMarker createMarker(String id) {
		
		MarkerJSNI mjsni = new MarkerJSNI();
		
		Marker marker	= new Marker(mjsni.createMarkerJS(raphaelPaper, id),id);

		marker.setImpl(mjsni);
		
		return marker;
	}
	
	
	@Override
	public IPath createPath(String path,float x,float y) {
		
		PathJSNI pjsni = new PathJSNI();

		Path p			= new Path(pjsni.createPath(raphaelPaper, path),path,x,y);

		p.setImpl(pjsni);
		
		p.setX(x);
		p.setY(y);
		
		return p;
	}

	
	

	@Override
	public ILinearPath createLinearPath(float x, float y) {
		
		PathJSNI pjsni = new PathJSNI();

		LinearPath p		= new LinearPath(pjsni.createPath(raphaelPaper, "M "+x+","+y),x,y);

		p.setImpl(pjsni);
		
		p.setX(x);
		p.setY(y);
		
		
		return p;
	}

	
	

	@Override
	public IRectangle createRectangle(float rx, float ry, float width, float height) {
		
		RectangleJSNI rjsni = new RectangleJSNI();
		
		Rectangle rect		= new Rectangle(rjsni.createRectangleJS(raphaelPaper, rx, ry, width, height), rx, ry, width, height);
		
		rect.setImpl(rjsni);
		
		return rect;
	}

	public IRectangle createRectangle(float rx, float ry, float width, float height,double cornersRadius) {
		
		RectangleJSNI rjsni = new RectangleJSNI();
		
		Rectangle rect		= new Rectangle(rjsni.createRectangleJS(raphaelPaper, rx, ry, width, height), rx, ry, width, height,cornersRadius);
		
		rect.setImpl(rjsni);
		rect.setRoundedCornersRadius(cornersRadius);
		
		return rect;
	}

	
	
	@Override
	public IText createText(float x, float y, String text) {
		
		TextJSNI tjsni		= new TextJSNI();
		
		Text txt			= new Text(tjsni.createTextJS(raphaelPaper, x, y, text), text, x, y);
		
		txt.setImpl(tjsni);
		
		return txt;
	}
	
	
	
	
	/**
	 * Getters
	 */

	@Override
	public HashSet<ISVGElement> getChildren() {return null;}

	@Override
	public String getDesc() {return null;}

	@Override
	public ISVGElement getElementById(String id) {return null;}

	@Override
	public float getHeight() {return 0;}

	@Override
	public String getTitle() {return null;}

	@Override
	public float getWidth() {return 0;}

	
	
	/**
	 * Setters
	 */
	
	@Override
	public void removeChild(ISVGElement svgElement) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setDesc(String desc) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setHeight(float height) {
		this.height = height;
		this.setHeightJS(raphaelPaper,height, width);
	}

	@Override
	public void setTitle(String title) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setWidth(float width) {
		this.width = width;
		this.setWidthJS(raphaelPaper,width, height);
	}


	@Override
	public void appendChild(ISVGElement svgElement) {
		
		SVGElement svgEl = (SVGElement) svgElement;
		
		this.appendChildJS(raphaelPaper, ((SVGElementJSNI)svgEl.getImpl()).getSvgElementJsObject());
		
	}
	

	/**
	 * JSNI IMPL
	 */
	
	public native void setDescJS(String desc)/*-{
	
		
	
	}-*/;



	public native void setHeightJS(JavaScriptObject doc,float height,float width)/*-{
	
		doc.setSize(width,height);
	
	}-*/;


	
	public native void setTitleJS(String title)/*-{
	
	
	
	}-*/;


	
	public native void setWidthJS(JavaScriptObject doc,float width,float height)/*-{
	
		doc.setSize(width,height);
	
	}-*/;


	public native void appendChildJS(JavaScriptObject doc,JavaScriptObject child)/*-{
		
		doc.appendChild(child);
	
	}-*/;



	@Override
	public int getAbsoluteLeft() {
		// TODO Auto-generated method stub
		return 0;
	}






	@Override
	public int getAbsoluteTop() {
		// TODO Auto-generated method stub
		return 0;
	}















}
