/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;

public class DefaultRightResizeUIHandler extends DefaultLeftResizeUIHandler{

	public DefaultRightResizeUIHandler(IUIPanel uiPanel) {
		super(uiPanel);
		this.setStyleName("uiPanel-right-ResizeBck");
		Image tmpImg = (Image) this.getIncreaseBtn();
		increaseBtn	 = (Image) this.getDecreaseBtn();
		decreaseBtn  = tmpImg;
		
		increaseBtn.setTitle("Click to increase panel height");
		decreaseBtn.setTitle("Click to decrease panel height");
	}

	@Override
	public void refresh() {
		this.setPixelSize(getWidth(), getHeight());
		
		//set btns position
		int panelHeightMiddle = getHeight()/2;
		this.getMainPanel().setWidgetPosition((Widget)getIncreaseBtn(), 7, panelHeightMiddle-23);
		this.getMainPanel().setWidgetPosition((Widget)getDecreaseBtn(), 7, panelHeightMiddle+23);
		
	}
	
	
}
