/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.uipanel;

import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IPanelDragDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IPanelSelectorDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.ISelectionMarkerDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanelResizeDefaultHandler;

public class UIPanelDefaultHandlers implements IUIPanelDefaultHandlers{
	
	private IUIPanel uipanel;
	
	private IPanelDragDefaultHandlers dragHandlers;
	private ISelectionMarkerDefaultHandlers selectionHandlers;
	private IPanelSelectorDefaultHandlers selectorHandlers;
	private IUIPanelResizeDefaultHandler resizeHandlers;
	
	public UIPanelDefaultHandlers(IUIPanel uipanel) {
		
		this.uipanel = uipanel;
		
		this.selectorHandlers = new UIPanelSelectorDefaultHandlers(uipanel);
		this.dragHandlers	  = new UIPanelDragDefaultHandlers(uipanel);
		this.resizeHandlers	  = new UIPanelResizeDefaultHandlers(uipanel);
	}
	
	@Override
	public IPanelDragDefaultHandlers getPanelDragDefaultHandlers() {
		return dragHandlers;
	}

	@Override
	public ISelectionMarkerDefaultHandlers getPanelSelectionDefaultHandlers() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IPanelSelectorDefaultHandlers getPanelSelectorDefaultHandlers() {
		return selectorHandlers;
	}

	@Override
	public void attachDefaultHandlers() {
		dragHandlers.attachDefaultHandlers();
		selectorHandlers.attachDefaultHandlers();
		resizeHandlers.attachDefaultHandlers();
	}

	@Override
	public IUIPanel getUIPanel() {
		return uipanel;
	}

	@Override
	public IUIPanelResizeDefaultHandler getPanelResizeDefaultsHandlers() {
		return resizeHandlers;
	}

}
