/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.api.core;

import java.util.LinkedHashMap;

import com.ebmwebsourcing.geasytools.geasyui.api.core.events.IContainerHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.event.dom.client.HasAllMouseHandlers;
import com.google.gwt.event.shared.HasHandlers;

/**
 * A container contains ... guess what ??
 * 
 * A container acts as a containment entity for all {@link IUIElement} in it.
 * 
 * Default container is {@link IUIPanel} .
 * 
 * @author nfleury
 *
 */
public interface IContainer extends HasAllMouseHandlers,HasHandlers{
	
	String getId();
	
	LinkedHashMap<String, IUIElement> getChildrenUIElements();
	
	void addUIElement(IUIElement uiElement);
	
	void removeChildElement(IUIElement uiElement);
	
	void removeAllChildren();
	
	int getAbsoluteTop();
	
	int getScrollTop();
	
	int getScrollLeft();

	int getClientWidth();
	
	int getClientHeight();
	
	int getAbsoluteLeft();
	
	IUIElementFactory getElementFactory();
	
	IContainerDefaultHandler getContainerDefaultHandler();

	void addContainerHandler(IContainerHandler handler);

}
