/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.droppable;

import java.util.ArrayList;
import java.util.HashSet;

import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDDManager;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Region;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.AcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.events.RefusedBeforeDropEvent;
import com.google.gwt.user.client.Window;


/**
 * 
 *
 * @author nfleury
 * 
 */
@SuppressWarnings("unchecked")
public class DDManager implements IDDManager{
	
	private ArrayList<Region<IDroppableElement>> droppableRegionsCache;
	private ArrayList<IDroppableElement> droppables;
	private IUIPanel uiPanel;
	private Region<IUIPanel> uiPanelRegion;
	
	private HashSet<IDroppableElement> droppablesHasMouseOver;

	
	private String  currentDroppableId;
	
	public DDManager(IUIPanel uipanel) {
		
		droppableRegionsCache 	= new ArrayList<Region<IDroppableElement>>();
		droppables		 		= new ArrayList<IDroppableElement>();
		droppablesHasMouseOver 	= new HashSet<IDroppableElement>();
		uiPanel 				= uipanel;


	}
	
	
	@Override
	public void addDroppable(IDroppableElement droppable) {
		droppables.add(droppable);
	}

	@Override
	public void dragStartElement(IDraggableElement draggedStartElement) {

		uiPanelRegion			= new Region<IUIPanel>(uiPanel.getNorthWestPoint(), uiPanel.getSouthEastPoint(), uiPanel);
		
		droppableRegionsCache.clear();
		droppablesHasMouseOver.clear();
		//cache all droppables as region in reverse order
		//in order to deal with DOM BUBBLING
		//=> last added may receive events first

		for(int size = getDroppables().size()-1;size>=0;size--){
			
			IDroppableElement droppable = getDroppables().get(size);
			
			Region<IDroppableElement> dR = new Region<IDroppableElement>(droppable.getNorthWestPoint(), droppable.getSouthEastPoint(),droppable);
			
			droppableRegionsCache.add(dR);
			
			
		}
		
	}

	@Override
	public void releasingDragElement(IDraggableElement draggedStoppedElement,
			float x, float y) {

		
		Point mousePointer = new Point(x+Window.getScrollLeft(),y+Window.getScrollTop());
		

	
			//if one of the droppable regions contains the mouse pointer
			//draggable is over droppable
			
			
			//A way to prevent bubbling on DROP
			boolean droppableHasDrop = false;
			
			
			
			for(int i=0;i<=droppableRegionsCache.size()-1;i++){
				
				Region<IDroppableElement> droppableRegion = droppableRegionsCache.get(i);
				
				//dont even bother if current dragged element is the Droppable
				if (droppableRegion.getSubject().getId().equals(draggedStoppedElement.getId())) continue;
				
				//System.out.println("droppable "+droppableRegion.getSubject().getId()+" NW point:"+droppableRegion.getSubject().getNorthWestPoint()+ "SE point:"+droppableRegion.getSubject().getSouthEastPoint());
				
				if (droppableRegion.contains(mousePointer)){
	
					//notify the drop event
					if (droppableRegion.getSubject().getAcceptedTypes().containsAll(draggedStoppedElement.getDraggedTypes())){
						
						//calculate x,y based on absolute positions
						x = draggedStoppedElement.getAbsoluteLeft() - droppableRegion.getSubject().getAbsoluteLeft() + droppableRegion.getSubject().getContainer().getScrollLeft();
						y = draggedStoppedElement.getAbsoluteTop() - droppableRegion.getSubject().getAbsoluteTop()  + droppableRegion.getSubject().getContainer().getScrollTop();
						
						//System.out.println("X:"+x+" Y:"+y + "container sT:" + droppableRegion.getSubject().getContainer().getScrollTop() +" container sL:"+droppableRegion.getSubject().getContainer().getScrollLeft());
						
						//notify droppable that drop has been accepted
						DropAcceptedEvent dropAcceptedEvent = new DropAcceptedEvent(draggedStoppedElement, x, y);
						droppableRegion.getSubject().fireEvent(dropAcceptedEvent);
						
						//notify draggable that drop has been accepted
						draggedStoppedElement.fireEvent(new AcceptedAfterDropEvent(droppableRegion.getSubject(), dropAcceptedEvent));

						droppableHasDrop = true;

					}else{
						
						//calculate x,y based on absolute positions
						x = draggedStoppedElement.getAbsoluteLeft() - droppableRegion.getSubject().getAbsoluteLeft();
						y = draggedStoppedElement.getAbsoluteTop() - droppableRegion.getSubject().getAbsoluteTop();

						//notify droppable that drop has been refused
						DropRefusedEvent dropRefusedEvent = new DropRefusedEvent(draggedStoppedElement, x, y);
						droppableRegion.getSubject().fireEvent(dropRefusedEvent);
						
						//notify draggable that drop has been refused
						draggedStoppedElement.fireEvent(new RefusedAfterDropEvent(droppableRegion.getSubject(), dropRefusedEvent));
						
						droppableHasDrop = true;
					}
					
					
					break;
					
				}
				
			}
			
			//PREVENT DROP BUBBLING
			//UIPanel receives drop event only if a droppable didnt already received
			//a droppable 
			if (droppableHasDrop==false){
			
				//first check if dragging element is over uiPanelRegion
				if (uiPanelRegion.contains(mousePointer)){
	
					//calculate x,y based on absolute positions
					x = draggedStoppedElement.getAbsoluteLeft() - 	uiPanel.getAbsoluteLeft() + uiPanel.getScrollLeft();
					y = draggedStoppedElement.getAbsoluteTop() 	- 	uiPanel.getAbsoluteTop() + uiPanel.getScrollTop() ;
					
					//notify the drop event
					if (uiPanel.getAcceptedTypes().containsAll(draggedStoppedElement.getDraggedTypes())){
							
						//notify drop accepted on uipanel
						DropAcceptedEvent dropAcceptedEvent = new DropAcceptedEvent(draggedStoppedElement, x, y); 
						uiPanel.fireEvent(dropAcceptedEvent);
						
						//notify to dragged element that drop was accepted
						draggedStoppedElement.fireEvent(new AcceptedAfterDropEvent(uiPanel, dropAcceptedEvent));
						
					}else{
	
						//notify drop refused on uipanel
						DropRefusedEvent dropRefusedEvent = new DropRefusedEvent(draggedStoppedElement, x, y); 
						uiPanel.fireEvent(dropRefusedEvent);
					
						//notify to dragged element that drop was refused
						draggedStoppedElement.fireEvent(new RefusedAfterDropEvent(uiPanel, dropRefusedEvent));
					}
					
				}
					
			}
		
	}

	@Override
	public void draggingElement(IDraggableElement draggedElement, float x, float y) {

		Point mousePointer = new Point(x+Window.getScrollLeft(),y+Window.getScrollTop());
		
		//first check if dragging element is over uiPanelRegion
		if (uiPanelRegion.contains(mousePointer)){
		
			//uiPanel.onOver(draggedElement);
			uiPanel.fireEvent(new OverEvent(draggedElement));
		
			
			//notify draggable if it can be dropped
			if (uiPanel.getAcceptedTypes().containsAll(draggedElement.getDraggedTypes())){

				draggedElement.fireEvent(new AcceptedBeforeDropEvent(uiPanel));
			
			}else{
				
				draggedElement.fireEvent(new RefusedBeforeDropEvent(uiPanel));
			
			}
			
		}else{
			
			//uiPanel.onOut(draggedElement);
			uiPanel.fireEvent(new OutEvent(draggedElement));
			
			//as we are no more in uiPanel we cannot accept any drop
			draggedElement.fireEvent(new RefusedBeforeDropEvent(uiPanel));
			
		}
		

		//if one of the droppable regions contains the mouse pointer
		//draggable is over droppable

		for(int i=0;i<=droppableRegionsCache.size()-1;i++){
			
			Region<IDroppableElement> droppableRegion 	= droppableRegionsCache.get(i);
			boolean currentDroppableHasMouseOver 		= droppablesHasMouseOver.contains(droppableRegion.getSubject());	
			
			
//			
//			System.out.println("Mouse Pointer:"+mousePointer);
//			System.out.println("Current dragged element Id:"+draggedElement.getId()
//					+"\n droppable: "+droppableRegion.getSubject().getId()
//					+"\n NW point:"+droppableRegion.getSubject().getNorthWestPoint()
//					+"\n SE point:"+droppableRegion.getSubject().getSouthEastPoint() 
//					+"\n droppableRegion contains mouse pointer:"+droppableRegion.contains(mousePointer));
//			System.out.println("HasMouseOver:"+currentDroppableHasMouseOver);



			//dont even bother if current dragged element is the Droppable
			if (droppableRegion.getSubject().getId().equals(draggedElement.getId())){continue;}
			
			
			//dont event bother if current draggedElement is the container of actual droppable
			if (droppableRegion.getSubject().getContainer().getId().equals(draggedElement.getId())){
				continue;
			}
			
			
//			System.out.println("droppable ID:"+droppableRegion.getSubject().getId());
//			System.out.println("droppableRegion.contains(mousePointer)"+droppableRegion.contains(mousePointer));
//			System.out.println("currentDroppableHasMouseOver"+currentDroppableHasMouseOver);
			if (droppableRegion.contains(mousePointer) ){
				
				
				///TODO: SUSPECT BEHAVIOR: WHY CANT WE FIRE THE OVEREVENT FIRST !?
				//It doesn't provoke any error but simply doesn't work ...
				
				//notify draggable if it can be dropped
				if (droppableRegion.getSubject().getAcceptedTypes().containsAll(draggedElement.getDraggedTypes())){
					draggedElement.fireEvent(new AcceptedBeforeDropEvent(droppableRegion.getSubject()));
				}else{
					draggedElement.fireEvent(new RefusedBeforeDropEvent(droppableRegion.getSubject()));
				}
				
				droppableRegion.getSubject().fireEvent(new OverEvent(draggedElement));
				
				//droppableHasMouseOver = true;
				droppablesHasMouseOver.add(droppableRegion.getSubject());
				currentDroppableId    = droppableRegion.getSubject().getId(); 
				
				
				
				
				
				break;//breaking prevent Bubbling
				
			}else if (droppableRegion.contains(mousePointer)==false 
					&& currentDroppableHasMouseOver==true 
					&& droppableRegion.getSubject().getId().equals(currentDroppableId) ){
				
				//droppableRegion.getSubject().onOut(draggedElement);
				droppableRegion.getSubject().fireEvent(new OutEvent(draggedElement));
				
				//droppableHasMouseOver = false;
				droppablesHasMouseOver.remove(droppableRegion.getSubject());
				
				break;//breaking prevent Bubbling
				
			}
			
		}
		
		
		
	}
	

	
	
	
	@Override
	public ArrayList<IDroppableElement> getDroppables() {
		return droppables;
	}

	@Override
	public IUIPanel getUIPanel() {
		return uiPanel;
	}


	@Override
	public void removeDroppable(IDroppableElement droppable) {
		
		for(int i=0;i<droppables.size();i++){
			if (droppable.getId().equals(droppables.get(i).getId())){
				droppables.remove(i);
			}
		}
		
		this.droppableRegionsCache.clear();
	}


}
