/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.core;



import com.ebmwebsourcing.geasytools.geasyui.api.core.IContainer;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IMouseState;
import com.ebmwebsourcing.geasytools.geasyui.api.core.IUIElement;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public abstract class UIElement extends Composite implements IUIElement{

	private IUIPanel uiPanel;
	private MouseState mouseState;
	private IContainer container;
	protected HandlerManager handlerManager;
	
	
	
	public UIElement(IUIPanel uiPanel, String id) {
		
		this.uiPanel 		 = uiPanel;
		this.container		 = uiPanel;
		this.mouseState 	 = new MouseState();
		
		this.handlerManager = new HandlerManager(this);
		
		initWidget(getMainWidget());
		
		this.getElement().setId(id);
	}
	
	@Override
	protected void onAttach() {
		super.onAttach();
	}
	
	@Override
	public void fireEvent(GwtEvent<?> event) {
		super.fireEvent(event);
		handlerManager.fireEvent(event);
	}
	
	@Override
	public IContainer getContainer() {
		return this.container;
	}


	@Override
	public String getId() {
		return this.getElement().getId();
	}



	@Override
	public IMouseState getMouseState() {
		return this.mouseState;
	}


	@Override
	public IUIPanel getUIPanel() {
		return this.uiPanel;
	}


	@Override
	public void setContainer(IContainer container) {
		this.container = container;
	}


	@Override
	public void setUIPanel(IUIPanel uiPanel) {
		this.uiPanel = uiPanel;
	}

	@Override
	public float getRelativeX() {
		return this.getAbsoluteLeft() - this.getContainer().getAbsoluteLeft();
	}

	@Override
	public float getRelativeY() {
		return this.getAbsoluteTop() - this.getContainer().getAbsoluteTop();
	}
	
	public HandlerManager getHandlerManager() {
		return handlerManager;
	}
	
	@Override
	public boolean equals(Object arg0) {
		
		IUIElement elToCompare = (IUIElement) arg0;
		
		if (elToCompare.getId().equals(this.getId())) return true;
		
		return false;
	}
	
	@Override
	public int hashCode() {
		return this.getId().hashCode();
	}
	
	
	public abstract Widget getMainWidget();	
}
