/**
 * geasy-widgets - Some useful widgets - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.widgets.ext.impl.file;

import java.util.List;

import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolderPanel;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.impl.file.event.FoldersLoadedEvent;
import com.google.gwt.user.client.ui.Composite;

public abstract class FolderPanel extends Composite implements IFolderPanel{
	
	private List<IFolder> folders;
	
	
	@Override
	public void addHandler(IFolderPanelHandler handler) {
		this.addHandler(handler, FoldersLoadedEvent.TYPE);
		this.addHandler(handler, FolderSelectedEvent.TYPE);
	}

	@Override
	public void setFolders(List<IFolder> folders) {
		this.folders = folders;
		this.fireEvent(new FoldersLoadedEvent());
	}

	@Override
	public List<IFolder> getFolders() {
		return folders;
	}

}
