/**
 * geasywsdl-domain - Domain Implementation for WSDL Schema Definition Language - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywsdl.domain;

import java.util.HashSet;
import java.util.Set;

import com.ebmwebsourcing.geasywsdl.domain.api.IBinding;
import com.ebmwebsourcing.geasywsdl.domain.api.IOperation;
import com.ebmwebsourcing.geasywsdl.domain.api.IPortType;

/**
 * @author Nicolas Boissel-Dallier - Petals Link
 */
public class Binding extends AbstractNamedElement implements IBinding {

	private static final long serialVersionUID = -7801434818179933096L;

	private IPortType portType;
	private Set<IOperation> operations = new HashSet<IOperation>();

	@Override
	public IPortType getPortType() {
		return portType;
	}

	@Override
	public void setPortType(IPortType porttype) {
		this.portType = porttype;
	}

	@Override
	public Set<IOperation> getOperations() {
		return operations;
	}

	@Override
	public void addOperation(IOperation operation) {
		operations.add(operation);
	}

	
}
