/**
 * geasywsdl-service - A Web based designer for WSDL 2.0 standard - Copyright (C) 2011 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasywsdl.service.serverToClient;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Import;

import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.geasyschema.domain.api.IElement;
import com.ebmwebsourcing.geasyschema.domain.api.ISchema;
import com.ebmwebsourcing.geasyschema.service.serverToClient.SchemaParser;
import com.ebmwebsourcing.geasywsdl.domain.Binding;
import com.ebmwebsourcing.geasywsdl.domain.Operation;
import com.ebmwebsourcing.geasywsdl.domain.Port;
import com.ebmwebsourcing.geasywsdl.domain.PortType;
import com.ebmwebsourcing.geasywsdl.domain.Service;
import com.ebmwebsourcing.geasywsdl.domain.Types;
import com.ebmwebsourcing.geasywsdl.domain.api.IBinding;
import com.ebmwebsourcing.geasywsdl.domain.api.IDefinitions;
import com.ebmwebsourcing.geasywsdl.domain.api.IOperation;
import com.ebmwebsourcing.geasywsdl.domain.api.IPort;
import com.ebmwebsourcing.geasywsdl.domain.api.IPortType;
import com.ebmwebsourcing.geasywsdl.domain.api.IService;
import com.ebmwebsourcing.geasywsdl.domain.api.ITypes;
import com.ebmwebsourcing.geasywsdl.domain.api.IWsdlNamedElement;

public class DefinitionsParser {

	public IDefinitions parseDefinitions(Description description) {
		return this.parseDefinitions(description, new HashSet<String>());
	}
	
	public IDefinitions parseDefinitions(Definitions definitions){
		Description desc = (Description) Factory.getInstance().wrap(definitions);
		return this.parseDefinitions(desc);
	}
	
    private IDefinitions parseDefinitions(Description description, Set<String> importLocations) {
        IDefinitions idefs = new com.ebmwebsourcing.geasywsdl.domain.Definitions();
        
        // TargetNamespace
        idefs.setTargetNamespace(description.getTargetNamespace());
        
        // Import
        for(IDefinitions impt : this.parseImports(description, importLocations)){
        	idefs.addImport(impt);
        }
        
        // Types
        if(description.getTypes() != null) {
            ITypes types = new Types();
            SchemaParser schemaParser = new SchemaParser();
            for(Schema s : description.getTypes().findXmlAnyObjects(Schema.class)) {
                types.addSchema(schemaParser.parseSchema(s));
            }
            idefs.setTypes(types);
        }       
        
        // PortType
        for(org.petalslink.abslayer.service.api.Interface inter : description.getInterfaces()){
        	IPortType iPortType = new PortType();
        	iPortType.setName(inter.getQName().getLocalPart());
        	for(org.petalslink.abslayer.service.api.Operation op : inter.getOperations()){
        		IOperation iOp = new Operation();
        		iOp.setName(op.getName());
        		
        		if(op.getInput() != null){
            		Element inElem = op.getInput().getElement();
            		if(inElem != null){
            			QName inQName = inElem.inferQName();
            			IElement in = this.findElement(idefs.getTypes().getSchemas(), inQName);
            			iOp.setInput(in);
            		}
        		}
        		
        		if(op.getOutput() != null){
            		Element outElem = op.getOutput().getElement();
            		if(outElem != null){
            			QName outQName = outElem.inferQName();
            			IElement out = this.findElement(idefs.getTypes().getSchemas(), outQName);
            			iOp.setOutput(out);
            		}
        		}
        		
         		iPortType.addOperation(iOp);
        	}
        	idefs.addPortType(iPortType);
        }
        
        // Binding
        for(org.petalslink.abslayer.service.api.Binding binding : description.getBindings()){
        	IBinding iBind = new Binding();
        	iBind.setName(binding.getQName().getLocalPart());
        	iBind.setPortType((IPortType) this.findWsdlElement(idefs.getPortTypes(), 
        								binding.getInterface().getQName().getLocalPart()));
        	
        	for(org.petalslink.abslayer.service.api.BindingOperation bindOp : binding.getOperations()){
        		if(iBind.getPortType() != null){
        			iBind.addOperation((IOperation) this.findWsdlElement(iBind.getPortType().getOperations(), bindOp.getName()));
        		}
        	}
        	
        	idefs.addBinding(iBind);
        }
        
        // Service & Port
        for(org.petalslink.abslayer.service.api.Service service : description.getServices()){
        	IService iServ = new Service();
        	iServ.setName(service.getQName().getLocalPart());
        	for(org.petalslink.abslayer.service.api.Endpoint endpoint : service.getEndpoints()){
        		IPort iEnd = new Port();
        		iEnd.setName(endpoint.getName());
        		iEnd.setLocation(endpoint.getAddress());
        		iEnd.setBinding((IBinding) this.findWsdlElement(idefs.getBindings(), 
        								endpoint.getBinding().getQName().getLocalPart()));
        		iServ.addPort(iEnd);
        	}
        	idefs.addService(iServ);
        }
        
        return idefs;
    }
    
	private Set<IDefinitions> parseImports(Description description, Set<String> importLocations) {
		Set<IDefinitions> imports = new HashSet<IDefinitions>();
    	
    	for(Import impt : description.getImports()){
    		if(! importLocations.contains(impt.getLocation())){
    			Description imptWsdl = impt.getImportDescription();
    			importLocations.add(impt.getLocation());
    			imports.add(parseDefinitions(imptWsdl, importLocations));
    		}
    	}
    	
    	return imports;
	}

	private IWsdlNamedElement findWsdlElement(Set<? extends IWsdlNamedElement> source, String name){
    	Iterator<? extends IWsdlNamedElement> it = source.iterator();
    	while(it.hasNext()){
    		IWsdlNamedElement elem = it.next();
    		if(elem.getName().equals(name)){
    			return elem;
    		}
    	}
    	return null;
    }
    
    
    private IElement findElement(Set<ISchema> schemas, QName elemName){
    	IElement result = null;
    	Iterator<ISchema> it = schemas.iterator();
    	while(result == null && it.hasNext()){
    		result = it.next().findElementInSchemas(elemName.getNamespaceURI(), elemName.getLocalPart());
    	}
    	return result;
    }
    
}