package com.ebmwebsourcing.petalsview.service.dataexporter;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

import org.springframework.stereotype.Service;

import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.FlowRefAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.FlowStepErrorRefAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.adapter.FlowStepRefAdapter;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.FlowRefDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.FlowStepErrorRefDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.FlowStepParameterRefDTO;
import com.ebmwebsourcing.petalsview.service.dataexporter.dto.FlowStepRefDTO;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;

@Service("dataexporter")
public class ExporterImpl implements Exporter {

	@Resource(name = "flowRefManager")
	private FlowRefManager flowRefManager;
	
	@Resource(name="flowStepRefManager")
	private FlowStepRefManager flowStepRefManager;

	private FlowRefAdapter flowRefAdapter = new FlowRefAdapter();
	private FlowStepRefAdapter flowStepRefAdapter = new FlowStepRefAdapter();
	private FlowStepErrorRefAdapter flowStepErrorRefAdapter = new FlowStepErrorRefAdapter();

	
	public void exportReferential(final Writer output, final String[] idFlowRef)
			throws Exception {

//		final OutputStream file = new FileOutputStream(fileName);
		output.write(" <dataset xmlns=\"http://petalsView.com/dataset\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\""
						+ " xsi:schemaLocation=\"http://petalsView.com/dataset referential-dataset.xsd\">");

		Marshaller marshaller = prepareMarshaller();

		// Load Flow Referential
		loadFlowRef(idFlowRef, output, marshaller);

		output.write("</dataset>");
	}

	private void loadFlowRef(final String[] idFlowRef,
			final Writer output, Marshaller marshaller)
			throws JAXBException, FlowRefException {

		for (String id : idFlowRef) {

			FlowRef flowRef = flowRefManager.loadFlowRef(id);
			FlowRefDTO flowRefDTO = new FlowRefDTO();

			flowRefAdapter.populateDTO(flowRefDTO, flowRef);
			marshaller.marshal(flowRefDTO, output);

			loadStepRef(output, marshaller, flowRef);
		}
	}
	
	private void loadStepRef(final Writer output,
			Marshaller marshaller, FlowRef flowRef) throws JAXBException, FlowRefException {
		List<FlowStepRef> listFlowStepRef = flowStepRefManager.loadSteps(flowRef
				.getType());

		for (FlowStepRef flowStepRef : listFlowStepRef) {

			FlowStepRefDTO flowStepRefDTO = new FlowStepRefDTO();

			flowStepRefAdapter.populateDTO(flowStepRefDTO, flowStepRef);
			marshaller.marshal(flowStepRefDTO, output);

			loadStepParametersRef(output, marshaller, flowStepRef);

			laodStepErrorRef(flowStepRef);
		}
	}

	

	private void laodStepErrorRef(FlowStepRef flowStepRef) throws FlowRefException{
		List<FlowStepErrorRef> listFlowStepErrorRef = flowStepRefManager
				.loadStepRefErrors(flowStepRef.getId());
		for (FlowStepErrorRef flowStepErrorRef : listFlowStepErrorRef) {

			FlowStepErrorRefDTO flowStepErrorRefDTO = new FlowStepErrorRefDTO();

			flowStepErrorRefAdapter.populateDTO(flowStepErrorRefDTO,
					flowStepErrorRef);
		}
	}

	private void loadStepParametersRef(final Writer output,
			Marshaller marshaller, FlowStepRef flowStepRef)
			throws JAXBException {
		List<FlowStepParameterRefDTO> listFlowStepParamDTO = new ArrayList<FlowStepParameterRefDTO>();

		flowStepRefAdapter.populateParamDTO(listFlowStepParamDTO, flowStepRef
				.getParameterNames(), flowStepRef.getId());

		for (FlowStepParameterRefDTO flowStepParamRefDTO : listFlowStepParamDTO) {
			marshaller.marshal(flowStepParamRefDTO, output);
		}
	}

	private Marshaller prepareMarshaller()
			throws Exception {
		final JAXBContext jaxbContext = JAXBContext.newInstance(
				FlowRefDTO.class, FlowStepErrorRefDTO.class,
				FlowStepParameterRefDTO.class, FlowStepRefDTO.class);

		final Marshaller marshaller = jaxbContext.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
		marshaller.setProperty(Marshaller.JAXB_FRAGMENT, true);

		return marshaller;
	}

}
