package com.ebmwebsourcing.petalsview.service.dataloader;

import java.io.InputStream;

import org.springframework.transaction.annotation.Transactional;

@Transactional
public interface Dataloader 
{

    /**
     * Fill the database with information extracted from the given XML dataset,
     * referenced by the given URI String. The dataset schema
     * (dragon-dataset.xsd) is included in the Dragon web app (in the
     * 'WEB-INF/classes/dataset' folder).
     * 
     * @param xmlDataSetURI
     *            an URI String pointing on a xml dataset.
     * @throws DataLoaderException
     *             if an error occurs during dataset loading
     */
    @Transactional
    public void loadDataSet(String xmlDataSetURI) throws DataLoaderException;

    /**
     * Fill the database with information extracted from the given XML dataset,
     * provided as an {@link InputStream}. The dataset schema
     * (dragon-dataset.xsd) is included in the Dragon web app (in the
     * 'WEB-INF/classes/dataset' folder).
     * 
     * @param datasetStream
     * @throws DataLoaderException
     */
    @Transactional
    void loadDataset(InputStream datasetStream) throws DataLoaderException;
}
