/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowManager.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.service.flow;

import java.util.Date;
import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
//import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;

@Transactional
public interface FlowManager {

    @Transactional(readOnly = true)
    Flow load(final String id) throws FlowException;

    void remove(final String id) throws FlowException;

    String saveOrUpdate(final Flow flow) throws FlowException;
    
    @Transactional(readOnly = true)
    List<Flow> loadAll() throws FlowException;

    @Transactional(readOnly = true)
    List<Flow> loadAllStarted() throws FlowException;

    @Transactional(readOnly = true)
    List<Flow> loadByType(final int type) throws FlowException;

    @Transactional(readOnly = true)
    List<Flow> loadAllStartedByType(final int type) throws FlowException;

    @Transactional(readOnly = true)
    List<Flow> loadAllStartedByTypeWithDateFilter(final int type, final Date startDate,
            final Date endDate) throws FlowException;

    @Transactional(readOnly = true)
    List<Flow> loadAllStartedWithDateFilter(final Date startDate, final Date endDate) throws FlowException;

    @Transactional(readOnly = true)
    public List<Flow> loadUnknowsFlows() throws FlowException;
}
