package com.ebmwebsourcing.petalsview.service.flow;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;

@Transactional
public interface FlowStepManager {
	
	 void removeStep(final String flowId, final String meUUID, final String interfaceName,
	            final String serviceName, final String endpointName) throws FlowException;

	  @Transactional(readOnly = true)
	    List<FlowStep> loadSteps(final String id, final int type) throws FlowException;
	  
	  @Transactional(readOnly = true)
	    List<FlowStep> loadRunningSteps(final String flowId) throws FlowException;

	    @Transactional(readOnly = true)
	    FlowStep loadFlowStep(final String flowId, final String meUUID, final String interfaceName,
	            final String serviceName, final String endpointName) throws FlowException;

	    @Transactional(readOnly = true)
	    List<FlowStep> loadFlowSteps(final String flowId, final String interfaceName,
	            final String serviceName) throws FlowException;

	    @Transactional(readOnly = true)
	    List<String> loadUnknownParameters(final String interfaceName, final String serviceName) throws FlowException;

	    @Transactional(readOnly = true)
	    FlowStep loadFlowStep(final String flowStepId) throws FlowException;
	    
	    void addStep(final Flow flow, final FlowStep flowStep) throws FlowException;

	    void updateStep(final FlowStep flowStep) throws FlowException;
}
