/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FlowStepErrorRef.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.petalsview.persistence.model.flowref;

import java.io.Serializable;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.hibernate.annotations.ForeignKey;

import com.ebmwebsourcing.webcommons.persistence.bo.StringIdBaseObject;

/**
 * This class represents a functional flow step error definition.
 * 
 * @author Pierre SMEYERS, ofabre
 */
@Entity(name = "com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef")
@Table(name = "FLOWSTEPERRORREF", uniqueConstraints = { @UniqueConstraint(columnNames = {
        "flowstepref_id", "errorCode" }) })
public class FlowStepErrorRef extends StringIdBaseObject implements Comparable<FlowStepErrorRef>,
        Serializable {
    /**
	 * 
	 */
    private static final long serialVersionUID = 1115146910203142614L;

    // ========================================================================
    // === Attributes
    // ========================================================================

    private int errorCode;

    private String message;

    private FlowStepRef flowstepref;

    // ========================================================================
    // === Constructors
    // ========================================================================
    public FlowStepErrorRef() {
    }

    // ========================================================================
    // === Attributes Getters & Setters
    // ========================================================================

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(final int errorCode) {
        this.errorCode = errorCode;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "flowstepref_id")
    @ForeignKey(name = "FK_FLOWSTEPREF_id_FLOWSTEP")
    public FlowStepRef getFlowstepref() {
        return flowstepref;
    }

    public void setFlowstepref(FlowStepRef flowstepref) {
        this.flowstepref = flowstepref;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(final String message) {
        this.message = message;
    }

    public int compareTo(final FlowStepErrorRef obj) {
        if (this.equals(obj)) {
            return 0;
        }
        return Integer.valueOf(this.getErrorCode()).compareTo(Integer.valueOf(obj.getErrorCode()));
    }

    @Override
    public boolean equals(final Object other) {
        if (!(other instanceof FlowStepErrorRef))
            return false;
        FlowStepErrorRef castOther = (FlowStepErrorRef) other;
        return new EqualsBuilder().append(errorCode, castOther.errorCode).append(message,
                castOther.message).append(flowstepref, castOther.flowstepref).isEquals();
    }

	@Override
	public int hashCode() {
		return new HashCodeBuilder().append(errorCode).append(message).append(
				flowstepref).toHashCode();
	}
	
	 @Override
	    public String toString() {
	        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(
	                super.toString()).append("message", this.message).append("flowstepref", this.flowstepref)
	               .toString();
	    }
}
