/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.persistence.dao.flowref;

import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowParamsDetails;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowStepRefDAO;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.FlowWithParams;
import com.ebmwebsourcing.petalsview.persistence.dao.flowref.GlobalFlowParam;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.webcommons.persistence.dao.GenericHibernateDAOImpl;
import com.trg.search.IMutableSearch;
import com.trg.search.Search;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.dbcp.BasicDataSource;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository(value="flowStepRefDAO")
public class FlowStepRefDAOImpl
extends GenericHibernateDAOImpl<FlowStepRef, String>
implements FlowStepRefDAO {
    @Resource
    private BasicDataSource dataSource;

    @Autowired
    public FlowStepRefDAOImpl(@Qualifier(value="sessionFactory") SessionFactory factory) {
        super(factory);
    }

    @Override
    public List<FlowStepRef> loadByFlowType(int type) {
        return this.search((IMutableSearch)new Search().addFilterEqual("flowref.type", (Object)type));
    }

    @Override
    public FlowStepRef loadStartStepByFlowType(int type) {
        return (FlowStepRef)this.searchUnique((IMutableSearch)new Search().addFilterEqual("flowref.type", (Object)type).addFilterEqual("flowStartStep", (Object)true));
    }

    @Override
    public FlowStepRef loadEndStepByFlowType(int type) {
        return (FlowStepRef)this.searchUnique((IMutableSearch)new Search().addFilterEqual("flowref.type", (Object)type).addFilterEqual("flowEndStep", (Object)true));
    }

    @Override
    public FlowStepRef loadByFlowTypeIntNameServName(int type, String interfaceName, String serviceName) {
        return (FlowStepRef)this.searchUnique((IMutableSearch)new Search().addFilterEqual("flowref.type", (Object)type).addFilterEqual("interfaceName", (Object)interfaceName).addFilterEqual("serviceName", (Object)serviceName));
    }

    @Override
    public FlowStepRef loadStartStepByName(String name) {
        return (FlowStepRef)this.searchUnique((IMutableSearch)new Search().addFilterEqual("name", (Object)name));
    }

    @Override
    public List<GlobalFlowParam> getGlobalFlowParameters(short flowType) {
        String booleanValue = this.getBooleanValue();
        Session session = this.getSession();
        Query query = session.createSQLQuery("select p.name, s.serviceName, s.interfaceName, p.idx from FLOWREF f join FLOWSTEPREF s on f.id = s.flowref_id join FLOWREF_PARAMNAMES p on p.FLOWSTEPREF_id = s.id where f.type=:type and p.global = " + booleanValue + " order by s.id, p.idx ").setShort("type", flowType).setResultTransformer(Transformers.aliasToBean(GlobalFlowParam.class));
        List ret = query.list();
        return ret;
    }

    @Override
    public List<FlowWithParams> getFlowsWithParameters(final List<GlobalFlowParam> globalParams, short type, Date after, Date before) {
        Session session = this.getSession();
        final String requete = this.createQuery(globalParams, type, after, before);
        final ArrayList<FlowWithParams> ret = new ArrayList<FlowWithParams>();
        try {
            session.doWork(new Work(){

                public void execute(Connection connection) throws SQLException {
                    Statement stt = connection.createStatement();
                    ResultSet rs = stt.executeQuery(requete);
                    ArrayList<String> listElements = null;
                    while (rs.next()) {
                        Long longDate;
                        FlowWithParams flowWithParams = new FlowWithParams();
                        flowWithParams.setId(rs.getLong(1));
                        flowWithParams.setIdpetals(rs.getString(2));
                        if (rs.getLong(3) != 0L) {
                            longDate = rs.getLong(3);
                            Date startDate = new Date(longDate);
                            flowWithParams.setStartDate(startDate);
                        }
                        if (rs.getLong(4) != 0L) {
                            longDate = rs.getLong(4);
                            Date endDate = new Date(longDate);
                            flowWithParams.setEndDate(endDate);
                        }
                        flowWithParams.setStatus(rs.getInt(5));
                        listElements = new ArrayList<String>();
                        for (int i = 0; i < globalParams.size(); ++i) {
                            String element = rs.getString(i + 6);
                            listElements.add(element);
                        }
                        flowWithParams.setElement(listElements);
                        ret.add(flowWithParams);
                    }
                }
            });
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (ret != null) {
            for (FlowWithParams flow : ret) {
                if (flow.getEndDate() != null) continue;
                flow.setStatus(-1);
            }
        }
        return ret;
    }

    private String createQuery(List<GlobalFlowParam> globalParams, short type, Date after, Date before) {
        String booleanValue = this.getBooleanValue();
        StringBuffer queryBuf = new StringBuffer();
        queryBuf.append("select");
        queryBuf.append(" f.id ,f.idpetals, ffs.startDate, lfs.endDate, lfs.status ");
        for (int i = 0; i < globalParams.size(); ++i) {
            queryBuf.append(", p" + i + ".element ");
        }
        queryBuf.append(" from FLOW f ");
        String currentService = null;
        String currentInterface = null;
        int srvIdx = -1;
        for (int i = 0; i < globalParams.size(); ++i) {
            GlobalFlowParam curParam = globalParams.get(i);
            if (!curParam.getInterfaceName().equals(currentInterface) || !curParam.getServiceName().equals(currentService)) {
                currentInterface = curParam.getInterfaceName();
                currentService = curParam.getServiceName();
                queryBuf.append(" left join FLOWSTEP s" + ++srvIdx);
                queryBuf.append(" on s" + srvIdx + ".flow_id = f.idpetals and s" + srvIdx + ".serviceName = '" + curParam.getServiceName() + "' " + "and s" + srvIdx + ".interfaceName = '" + curParam.getInterfaceName() + "'");
            }
            queryBuf.append(" left join FLOW_PARAMS p" + i);
            queryBuf.append(" on p" + i + ".FLOWSTEP_id = s" + srvIdx + ".id and p" + i + ".idx = " + curParam.getIdx());
        }
        queryBuf.append(" left join FLOWREF fr ");
        queryBuf.append(" on fr.type = " + type);
        queryBuf.append(" left join FLOWSTEPREF ffsr ");
        queryBuf.append("on fr.id = ffsr.flowref_id and ffsr.flowstartstep = " + booleanValue);
        queryBuf.append(" left join FLOWSTEP ffs ");
        queryBuf.append("on ffs.flow_id = f.idpetals and ffs.serviceName = ffsr.serviceName  and ffs.interfaceName = ffsr.interfaceName ");
        queryBuf.append("left join FLOWSTEPREF lfsr ");
        queryBuf.append("on fr.id = lfsr.flowref_id and lfsr.flowendstep = " + booleanValue);
        queryBuf.append(" left join FLOWSTEP lfs ");
        queryBuf.append("on lfs.flow_id = f.idpetals and lfs.serviceName = lfsr.serviceName  and lfs.interfaceName = lfsr.interfaceName ");
        queryBuf.append(" where f.type = " + type);
        if (before != null || after != null) {
            queryBuf.append(" and ffs.startdate is not null ");
        }
        if (before != null) {
            queryBuf.append(" and ffs.startdate < '" + before.getTime() + "'");
        }
        if (after != null) {
            queryBuf.append(" and ffs.startdate > '" + after.getTime() + "' ");
        }
        queryBuf.append(" order by ffs.startdate, lfs.status, f.id");
        String requete = queryBuf.toString();
        return requete;
    }

    @Override
    public List<FlowParamsDetails> getDetailFlowParameter(short flowType, String flowId) {
        String booleanValue = this.getBooleanValue();
        Session session = this.getSession();
        Query query = session.createSQLQuery("select pr.name, pr.idx, p.element  from FLOWREF fr  join FLOWSTEPREF sr  on fr.id = sr.flowref_id  join FLOWREF_PARAMNAMES pr  on pr.FLOWSTEPREF_id = sr.id  left join FLOWSTEP s   on s.flow_id = '" + flowId + "' and s.serviceName = sr.serviceName and s.interfaceName = sr.interfaceName " + " left join FLOW_PARAMS p " + " on p.FLOWSTEP_id = s.id and p.idx = pr.idx " + " where " + " fr.type=" + flowType + " and pr.global = " + booleanValue + " order by sr.id, pr.idx").setResultTransformer(Transformers.aliasToBean(FlowParamsDetails.class));
        List ret = query.list();
        return ret;
    }

    private String getBooleanValue() {
        String value = null;
        String prop = this.dataSource.getDriverClassName();
        if (prop.equals("org.postgresql.Driver")) {
            value = "true";
            return value;
        }
        value = "1";
        return "1";
    }
}

