/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.service.notification;

import com.ebmwebsourcing.petalsview.service.notification.Notification;
import com.ebmwebsourcing.petalsview.service.notification.NotificationProcessingException;
import com.ebmwebsourcing.webcommons.util.XMLUtil;
import java.util.Date;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.Logger;

public class NotificationReader {
    private Logger logger = Logger.getLogger(NotificationReader.class);
    private XMLInputFactory factory = XMLInputFactory.newInstance();

    public NotificationReader() {
        this.factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
    }

    public Notification read(Source notifMessage) throws NotificationProcessingException {
        Notification notification = null;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"a notification is read");
        }
        try {
            notification = this.parseNotifMessage(notifMessage);
        }
        catch (Throwable e) {
            throw new NotificationProcessingException("unable to read the notification", e);
        }
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Notification parseNotifMessage(Source notifMessage) throws XMLStreamException {
        Notification notification = null;
        if (notifMessage != null) {
            notification = new Notification();
            Source source = null;
            if (notifMessage instanceof DOMSource) {
                try {
                    source = XMLUtil.toStreamSource((DOMSource)((DOMSource)notifMessage));
                }
                catch (Exception e) {
                    new NotificationProcessingException("Can't convert DOMSource to StreamSource", e);
                }
            } else {
                source = notifMessage;
            }
            XMLStreamReader parser = this.factory.createXMLStreamReader(source);
            try {
                int event = parser.next();
                while (event != 8) {
                    switch (event) {
                        case 1: {
                            if ("NotifyContent".equalsIgnoreCase(parser.getLocalName())) {
                                this.parseNotifElement(parser, notification);
                                break;
                            }
                            if (!"param".equalsIgnoreCase(parser.getLocalName())) break;
                            notification.addParam(parser.getElementText());
                            break;
                        }
                    }
                    event = parser.next();
                }
            }
            finally {
                parser.close();
            }
        }
        return notification;
    }

    private void parseNotifElement(XMLStreamReader parser, Notification notification) throws XMLStreamException {
        String status;
        notification.setProcessId(parser.getAttributeValue(null, "processPath"));
        String processType = parser.getAttributeValue(null, "processType");
        if (processType != null && !"".equals(processType)) {
            notification.setProcessType(Integer.parseInt(processType));
        }
        if ((status = parser.getAttributeValue(null, "status")) != null && !"".equals(status)) {
            notification.setStatus(Integer.parseInt(status));
        }
        notification.setInterfaceName(parser.getAttributeValue(null, "interface"));
        notification.setEndpointName(parser.getAttributeValue(null, "endpoint"));
        notification.setServiceName(parser.getAttributeValue(null, "service"));
        notification.setMeUUID(parser.getAttributeValue(null, "meuuid"));
        String notifDate = parser.getAttributeValue(null, "notifDate");
        if (notifDate != null && !"".equals(notifDate)) {
            notification.setNotifDate(new Date(Long.parseLong(notifDate)));
        }
    }
}

