/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * UserConfig.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans;

import java.util.Locale;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.ow2.opensuit.core.session.OpenSuitSession;

public class UserConfig
{
	/*
	public final static UserConfig getCurrent(HttpServletRequest request)
	{
		try
		{
			return (UserConfig)BeanUtils.getOpenSuitBean(OpenSuitSession.getCurrentRequest(), "userConfig");
		}
		catch (Exception e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
	*/
	
	@SuppressWarnings("static-access")
	public Locale getLocale()
	{
		HttpServletRequest request = OpenSuitSession.getCurrentRequest();
		Cookie[] cookies = request.getCookies();
		for(int i=0; i<cookies.length; i++)
		{
			if(cookies[i].getName().equals("lang"))
			{
//				System.out.println("cookie found: "+cookies[i].getValue());
				return new Locale(cookies[i].getValue());
			}
		}
		
		// --- otherwise return default locale
//		System.out.println("cookie not found - use default language: "+request.getRequestURL().toString());
		return OpenSuitSession.getSession(request).getCurrentApplication().getAllLanguages()[0].getLocale();
	}
	public void setLocale(Locale locale)
	{
		HttpServletRequest request = OpenSuitSession.getCurrentRequest();
		HttpServletResponse response = OpenSuitSession.getCurrentResponse();
		Cookie langCookie = new Cookie("lang", locale.getLanguage());
		langCookie.setPath(request.getContextPath());
		response.addCookie(langCookie);
	}
	public int getPaginationLength()
	{
		return 20;
	}
}
