/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * CreateFlowRef.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.referential;

import javax.servlet.http.HttpServletRequest;

import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;


/**
 * @author ofabre
 * 
 */
public class CreateFlowRef {

    private int type;

    private String stringType;

    private String name;

    private String idUnknowFlow;

    private boolean editType;

    private FlowRefManager flowRefManager;

    private FlowManager flowManager;
    


    public CreateFlowRef() {
        super();
        this.flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
    }

    public void init(HttpServletRequest request) throws Exception{
        String id = request.getParameter("idFlow");
        if (id != null) 
        {
            Flow flow = flowManager.load(id);
            idUnknowFlow = flow.getIdpetals();
            type = flow.getType();
            stringType = String.valueOf(type);
            editType = false;
        } else {
            idUnknowFlow ="null";
            editType = true;
            stringType = null;
        }

        name = null;
    }

    public String create() throws Exception {
        try {
            type = Integer.parseInt(stringType);
            flowRefManager.createFlowRef(type, name);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        }catch (FlowRefException e){
                NonLocalizedError error = new NonLocalizedError("create_flowref.constraint", null, e);
                error.setType(IError.FUNCTIONAL_ERROR);
                throw error;
        }
        // refresh ReferentialBean
        ReferentialBean.reload();
        return "success";
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIdUnknowFlow() {
        return idUnknowFlow;
    }

    public String getStringType() {
        return stringType;
    }

    public void setStringType(String stringType) {
        this.stringType = stringType;
    }

    public boolean isEditType() {
        return editType;
    }

    public void setEditType(boolean editType) {
        this.editType = editType;
    }

}
