/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * DataLoaderBean.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.referential;

import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.impl.multiparts.IFileUploadPart;
import org.springframework.util.StringUtils;

import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class DataLoaderBean {

    private Logger logger = Logger.getLogger(this.getClass());
    private String datasetLocation = null;
  

    
    public String loadDataset() throws LocalizedError,Exception {
        try {
            if (StringUtils.hasText(datasetLocation)) {
                PetalsViewServiceFactory.getInstance().getDataLoader().loadDataSet(datasetLocation);
            }
        } catch (Exception e) {
        	logger.error(e.getMessage(), e);
        	 NonLocalizedError error = new NonLocalizedError("Can't import Referential", e.getMessage(), e);
             error.setType(IError.FUNCTIONAL_ERROR);
             throw error;
        }
        ReferentialBean.reload();
        datasetLocation = null;
        return "success";
    }

    public String loadDataset(IFileUploadPart file) throws LocalizedError,Exception {
        try {
            PetalsViewServiceFactory.getInstance().getDataLoader().loadDataset(
                    file.getFileInputStream());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            NonLocalizedError error = new NonLocalizedError("Can't import Referential", e.getMessage(), e);
            error.setType(IError.FUNCTIONAL_ERROR);
            throw error;
        }
        ReferentialBean.reload();
        datasetLocation = null;
        return "success";
    }

    public String submit() {
        return "success";
    }


    public String getDatasetLocation() {
        return datasetLocation;
    }

    public void setDatasetLocation(String datasetLocation) {
        this.datasetLocation = datasetLocation;
    }

	
    
}
