/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * ListOfFlowRefs.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.referential;

import java.util.List;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowRef;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class ListOfFlowRefs {

    private FlowManager flowManager;

    private FlowRefManager flowRefManager;
    

    private List<FlowRef> flowRefs;

    private List<Flow> unknowsFlows;

    private int[] selection;

    private boolean viewUnknowsFlows;

    public ListOfFlowRefs() {
        super();
        this.flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
    }

    // ===============================================================
    // === control methods
    // ===============================================================
    public void loadAll() throws Exception {
        flowRefs = flowRefManager.loadAll();
        unknowsFlows = flowManager.loadUnknowsFlows();
        if (unknowsFlows != null && !unknowsFlows.isEmpty()) {
            viewUnknowsFlows = true;
        } else {
            viewUnknowsFlows = false;
        }
    }

    public String deleteSelected() throws Exception {
        flowRefManager.removeFlowRef(selection);
        // then reload
        loadAll();
        // refresh ReferentialBean
        ReferentialBean.reload();
        return "success";
    }

    // ===============================================================
    // === setters/getters
    // ===============================================================
    public List<FlowRef> getFlowRefs() {
        return flowRefs;
    }

    public int[] getSelection() {
        return selection;
    }

    public void setSelection(int[] selection) {
        this.selection = selection;
    }

    public List<Flow> getUnknowsFlows() {
        return unknowsFlows;
    }

    public void setUnknowsFlows(List<Flow> unknowsFlows) {
        this.unknowsFlows = unknowsFlows;
    }

    public boolean isViewUnknowsFlows() {
        return viewUnknowsFlows;
    }

    public void setViewUnknowsFlows(boolean viewUnknowsFlows) {
        this.viewUnknowsFlows = viewUnknowsFlows;
    }

}
