/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * StepRefDetails.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.referential;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import javax.servlet.http.HttpServletRequest; //import javax.xml.namespace.QName;

import org.hibernate.HibernateException;
import org.hibernate.exception.ConstraintViolationException;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;

import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.service.flow.FlowException;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManagerRuntimeException;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

/**
 * @author ofabre
 * 
 */
public class StepRefDetails {

    private String interfaceName;

    private String serviceName;

    private String endpointName;

    private String functionalName;

    private boolean startStep = false;

    private boolean endStep = false;

    private String successMessage;

    private String defaultErrorMessage;

    private int flowRefType;
    
    private String idStepRef;

    private FlowStepRef flowStepRef;

    private String[] selectedErrorIds;

    private int[] selectedParamIndexes;

    private int[] paramIndex;

    private List<String> allStepUnknownParameters;

    private int numberOfUnknownParams;

    private FlowRefManager flowRefManager;
    private FlowStepRefManager flowStepRefManager;

    //private FlowManager flowManager;
    
    private FlowStepManager flowStepManager;

    public StepRefDetails() {
        super();
        // this.flowManager =
        // PetalsViewServiceFactory.getInstance().getFlowManager();
        this.flowRefManager = PetalsViewServiceFactory.getInstance().getFlowRefManager();
        this.flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    // ===========================================================
    // === Control Methods
    // ===========================================================
    public void load(HttpServletRequest request) throws Exception{
        String id = request.getParameter("id");
        flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
        loadStepRef(id);
        paramIndex = new int[flowStepRef.getParameterNames().size()];
        for (int i = 0; i < paramIndex.length; i++) {
            paramIndex[i] = i;
        }
        loadUnknownParameters();
    }

    private void loadUnknownParameters() throws Exception{
        allStepUnknownParameters = flowStepManager.loadUnknownParameters(
                flowStepRef.getInterfaceName(), flowStepRef.getServiceName());
        if (allStepUnknownParameters != null && !allStepUnknownParameters.isEmpty()) {
            List<String> listTmp = new ArrayList<String>();
            for (int i = 0; i < flowStepRef.getParameterNames().size(); i++) {
                listTmp.add(flowStepRef.getParameterNames().get(i).getName());
            }

            for (int i = 0; i < allStepUnknownParameters.size(); i++) {
                if (listTmp != null && !listTmp.isEmpty()
                        || allStepUnknownParameters.size() > listTmp.size()) {
                    numberOfUnknownParams = allStepUnknownParameters.size() - listTmp.size();
                    if (numberOfUnknownParams < 0) {
                        numberOfUnknownParams = 0;
                    }
                }
            }
        }
    }

    private void loadFlowParams(String id) throws Exception {
        flowStepRef = flowStepRefManager.loadStepRef(id);
        idStepRef = flowStepRef.getId();
        selectedParamIndexes = new int[0];
    }

    public void init(HttpServletRequest request) throws FlowException{
        flowRefType = Integer.parseInt(request.getParameter("flowRefType"));
        String idStep = request.getParameter("idStep");
        if (idStep != null && !idStep.equals("0")) {
            FlowStep flowStep = flowStepManager.loadFlowStep(idStep);
            interfaceName = flowStep.getInterfaceName();
            serviceName = flowStep.getServiceName();
        }
    }

    private void loadStepRef(String id) throws Exception{
        flowStepRef = flowStepRefManager.loadStepRef(id);
        idStepRef = flowStepRef.getId();
        reset();
    }

    public void reset() {
        // endpointName = flowStepRef.getEndpointName();
        interfaceName = flowStepRef.getInterfaceName();
        serviceName = flowStepRef.getServiceName();
        functionalName = flowStepRef.getName();
        startStep = flowStepRef.isFlowStartStep();
        endStep = flowStepRef.isFlowEndStep();
        successMessage = flowStepRef.getSuccessMessage();
        defaultErrorMessage = flowStepRef.getDefaultErrorMessage();
        selectedErrorIds = new String[0];
    }

    public String create() throws LocalizedError, Exception {
        FlowStepRef flowStepRef = new FlowStepRef();
        flowStepRef.setFlowEndStep(endStep);
        flowStepRef.setFlowref(flowRefManager.getFlowRef(flowRefType));
        flowStepRef.setFlowStartStep(startStep);
        // flowStepRef.setEndpointName(endpointName);
        flowStepRef.setInterfaceName(interfaceName);
        flowStepRef.setName(functionalName);
        flowStepRef.setServiceName(serviceName);
        flowStepRef.setSuccessMessage(successMessage);
        flowStepRef.setDefaultErrorMessage(defaultErrorMessage);
        try {
        	flowStepRefManager.saveOrUpdateStepRef(flowStepRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        } catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("create_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        }
        return "success";
    }

    public String update() throws LocalizedError, Exception {
    	flowStepRef.setId(idStepRef);
        flowStepRef.setFlowEndStep(endStep);
        flowStepRef.setFlowStartStep(startStep);
        flowStepRef.setInterfaceName(interfaceName);
        flowStepRef.setName(functionalName);
        flowStepRef.setServiceName(serviceName);
        flowStepRef.setSuccessMessage(successMessage);
        flowStepRef.setDefaultErrorMessage(defaultErrorMessage);
        flowStepRef.setFlowref(flowRefManager.getFlowRef(flowRefType));

        try {
        	flowStepRefManager.saveOrUpdateStepRef(flowStepRef);
        } catch (ConstraintViolationException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        } catch (HibernateException e) {
            throw new LocalizedError("database", e);
        } catch (FlowRefManagerRuntimeException e) {
            LocalizedError le = new LocalizedError("update_flowstepref.constraint", e);
            le.setType(IError.FUNCTIONAL_ERROR);
            throw le;
        }
        return "success";
    }

    public String removeErrorRefs() throws Exception{
    	flowStepRefManager.removeErrorRefs(selectedErrorIds);
        loadStepRef(flowStepRef.getId());
        return "success";
    }

    public int[] makeIndexes(int size) {
        int[] ret = new int[size];
        for (int i = 0; i < ret.length; i++)
            ret[i] = i;
        return ret;
    }

    // --- Parameter Names Management Methods
    public String addParameterName(int index, String name, boolean global) throws Exception{
    	flowStepRefManager.addParameterName(flowStepRef.getId(), index, name, global);
        loadFlowParams(flowStepRef.getId());

        loadUnknownParameters();
        return "success";
    }

    public String updateParameterName(int index, String name, boolean global)throws Exception {
    	flowStepRefManager.updateParameterName(flowStepRef.getId(), index, name, global);
        loadFlowParams(flowStepRef.getId());
        return "success";
    }

    public String removeParameterNames() throws Exception{
    	flowStepRefManager.removeParameterNames(flowStepRef.getId(), selectedParamIndexes);
        loadFlowParams(flowStepRef.getId());
        loadUnknownParameters();
        return "success";
    }

    // ===========================================================
    // === Getters/Setters
    // ===========================================================
    public String getInterfaceName() {
        return interfaceName;
    }

    public void setInterfaceName(String interfaceName) {
        this.interfaceName = interfaceName;
    }

    public String getEndpointName() {
        return endpointName;
    }

    public void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    public int[] getParamIndex() {
        return paramIndex;
    }

    public String getServiceName() {
        return serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getFunctionalName() {
        return functionalName;
    }

    public void setFunctionalName(String functionalName) {
        this.functionalName = functionalName;
    }

    public boolean isStartStep() {
        return startStep;
    }

    public void setStartStep(boolean startStep) {
        this.startStep = startStep;
    }

    public boolean isEndStep() {
        return endStep;
    }

    public void setEndStep(boolean endStep) {
        this.endStep = endStep;
    }

    public String getSuccessMessage() {
        return successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public FlowStepRef getFlowStepRef() {
        return flowStepRef;
    }

    public void setFlowStepRef(FlowStepRef flowStepRef) {
        this.flowStepRef = flowStepRef;
    }

    public int getFlowRefType() {
        return flowRefType;
    }

    public void setFlowRefType(int flowRefType) {
        this.flowRefType = flowRefType;
    }

    public String[] getSelectedErrorIds() {
        return selectedErrorIds;
    }

    public void setSelectedErrorIds(String[] selectedErrorIds) {
        this.selectedErrorIds = selectedErrorIds;
    }

    public Collection<FlowStepErrorRef> getErrorMessages() {
        List<FlowStepErrorRef> flowErrorStepRefs = null;
        if (!(flowStepRef.getErrorMessages() == null || flowStepRef.getErrorMessages().size() == 0)) {
            flowErrorStepRefs = new ArrayList<FlowStepErrorRef>();
            flowErrorStepRefs.addAll(flowStepRef.getErrorMessages().values());
            Collections.sort(flowErrorStepRefs);
        }
        return flowErrorStepRefs;
    }

    public String getDefaultErrorMessage() {
        return defaultErrorMessage;
    }

    public void setDefaultErrorMessage(String defaultErrorMessage) {
        this.defaultErrorMessage = defaultErrorMessage;
    }

    public int[] getSelectedParamIndexes() {
        return selectedParamIndexes;
    }

    public void setSelectedParamIndexes(int[] selectedParamIndexes) {
        this.selectedParamIndexes = selectedParamIndexes;
    }

    public List<String> getAllStepUnknownParameters() {
        return allStepUnknownParameters;
    }

    public void setAllStepUnknownParameters(List<String> allStepUnknownParameters) {
        this.allStepUnknownParameters = allStepUnknownParameters;
    }

    public int getNumberOfUnknownParams() {
        return numberOfUnknownParams;
    }

    public void setNumberOfUnknownParams(int numberOfUnknownParams) {
        this.numberOfUnknownParams = numberOfUnknownParams;
    }

	/**
	 * @return the idStepRef
	 */
	public String getIdStepRef() {
		return idStepRef;
	}

	/**
	 * @param idStepRef the idStepRef to set
	 */
	public void setIdStepRef(String idStepRef) {
		this.idStepRef = idStepRef;
	}

	


    
}
