/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * StepDetails.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.persistence.model.flow.FlowStep;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepErrorRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.FlowStepRef;
import com.ebmwebsourcing.petalsview.persistence.model.flowref.StepParameter;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;

public class StepDetails {
    private FlowStep flowStep;

    private FlowStepRef flowStepRef;

    private int[] paramIndex;

    private FlowStepManager flowStepManager;
    private FlowStepRefManager flowStepRefManager;
    
    public StepDetails() {
        super();
        this.flowStepManager = PetalsViewServiceFactory.getInstance().getFlowStepManager();
        this.flowStepRefManager = PetalsViewServiceFactory.getInstance().getFlowStepRefManager();
    }

    public void load(HttpServletRequest request) throws Exception {
        String id = request.getParameter("id");
        flowStep = flowStepManager.loadFlowStep(id);
        List<String> listParam = flowStep.getParameters();
        flowStepRef = flowStepRefManager.loadStepRef(flowStep.getFlow().getType(), flowStep
                .getInterfaceName(), flowStep.getServiceName());
        if (flowStepRef != null) {
            paramIndex = new int[flowStepRef.getParameterNames().size()];
            for (int i = 0; i < paramIndex.length; i++)
                paramIndex[i] = i;
        }
       
        getListParam(listParam);
    }

    public void getListParam(List<String> listParam) {
        if (paramIndex != null) {
            if (listParam.isEmpty()) {
                for (int i = 0; i < paramIndex.length; i++) {
                    listParam.add("");
                }
            }

            if (listParam.size() < paramIndex.length) {
                while (listParam.size() < paramIndex.length) {

                    listParam.add(" ");
                }
            }
        } else {
            if (listParam.isEmpty()) {
                listParam.add("");
            } else {
                paramIndex = new int[listParam.size()];
                for (int i = 0; i < paramIndex.length; i++)
                    paramIndex[i] = i;

                List<StepParameter> listStepParam = new ArrayList<StepParameter>();

                for (int j = 0; j < paramIndex.length; j++) {
                    StepParameter stepParam = new StepParameter();
                    stepParam.setName("Unkown");
                    listStepParam.add(stepParam);
                }
                flowStepRef = new FlowStepRef();
                flowStepRef.setParameterNames(listStepParam);
            }
        }
    }

    public FlowStep getFlowStep() {
        return flowStep;
    }

    public FlowStep[] getFlowSteps() {
        return new FlowStep[] { flowStep };
    }

    public FlowStepRef getFlowStepRef() {
        return flowStepRef;
    }

    public int[] getParamIndex() {
        return paramIndex;
    }

    public String getStepName() {
        // By default, a step name is a concatenation of the interface name and
        // service name
        String result = flowStep.getInterfaceName() + "/" + flowStep.getServiceName();

        // If a flow ref is defined, we could use a more explicit step name
        if (flowStepRef != null) {

            result = flowStepRef.getName();
        }
        return result;
    }

    public String getShortStepName() {
        String result = "";

        // If a flow ref is defined, we could use an explicit step name
        if (flowStepRef != null) {
            result = flowStepRef.getName();
            if (result != null) {
                if (result.length() > 30) {
                    result = result.substring(0, 27) + "...";
                }
            } else {
                result = flowStep.getInterfaceName() + "/" + flowStep.getServiceName();
                if (result.length() > 30) {
                    String shortIntName = QName.valueOf(flowStep.getInterfaceName()).getLocalPart()
                            .length() > 11 ? QName.valueOf(flowStep.getInterfaceName())
                            .getLocalPart().substring(0, 10)
                            + "..." : QName.valueOf(flowStep.getInterfaceName()).getLocalPart();
                    String shortServName = QName.valueOf(flowStep.getServiceName()).getLocalPart()
                            .length() > 11 ? QName.valueOf(flowStep.getServiceName())
                            .getLocalPart().substring(0, 10)
                            + "..." : QName.valueOf(flowStep.getServiceName()).getLocalPart();
                    result = shortIntName + "/" + shortServName;
                }
            }

        } else {
            // By default, a step name is a concatenation of the interface name
            // and service name
            result = flowStep.getInterfaceName() + "/" + flowStep.getServiceName();
            if (result.length() > 30) {
                String shortIntName = QName.valueOf(flowStep.getInterfaceName()).getLocalPart()
                        .length() > 11 ? QName.valueOf(flowStep.getInterfaceName()).getLocalPart()
                        .substring(0, 10)
                        + "..." : QName.valueOf(flowStep.getInterfaceName()).getLocalPart();
                String shortServName = QName.valueOf(flowStep.getServiceName()).getLocalPart()
                        .length() > 11 ? QName.valueOf(flowStep.getServiceName()).getLocalPart()
                        .substring(0, 10)
                        + "..." : QName.valueOf(flowStep.getServiceName()).getLocalPart();
                result = shortIntName + "/" + shortServName;
            }
        }

        return result;
    }

    public String getStepKey() {
        return flowStep.getInterfaceName() + "/" + flowStep.getServiceName() + "/"
                + flowStep.getEndpointName() + "/" + flowStep.getMeUUID();
    }

    /**
     * Convert a flow status into a ui status (in_progress = 2, success = 0,
     * failure = 1)
     * 
     * @param status
     * @return
     */
    public int getUiStatus(int status) {
        if (status == Flow.SUCCESS_STATUS)
            return 0;
        else if (status == Flow.IN_PROGRESS_STATUS)
            return 2;
        else
            return 1;
    }

    public String getStepMessage() {
        if (flowStep.getStatus() == Flow.SUCCESS_STATUS) {
            return flowStepRef.getSuccessMessage();
        } else if (flowStep.getStatus() == Flow.IN_PROGRESS_STATUS) {
            return null;
        }
        // --- cas d'erreur
        // Retrieve the corresponding step ref
        FlowStepErrorRef error = flowStepRef.getErrorMessages().get(flowStep.getStatus());
        if (error == null) {
            // --- error code not registered
            return flowStepRef.getDefaultErrorMessage() != null ? flowStepRef
                    .getDefaultErrorMessage() : "Error " + flowStep.getStatus() + " (?)";
        }
        return error.getMessage();
    }
}
