/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * FullAccessRightsUserDetailsService.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.util;

import java.io.IOException;
import java.util.Properties;

import org.jasig.cas.client.validation.Assertion;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.security.cas.userdetails.AbstractCasAssertionUserDetailsService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.GrantedAuthorityImpl;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

/**
 * A UserDetailsService implementation that provides all access rights to all
 * logged users. Could be replaced by a custom user details service based on
 * your own user management environment (LDAP, JDBC...). To use with JA-SIG CAS.
 * 
 * @author ofabre
 * 
 */
public class FullAccessRightsUserDetailsService extends AbstractCasAssertionUserDetailsService {

    private static final String NON_EXISTENT_PASSWORD_VALUE = "NO_PASSWORD";

    private Resource rolesResource;

    @SuppressWarnings("deprecation")
	@Override
    public UserDetails loadUserDetails(Assertion assertion) throws UsernameNotFoundException {
        try {
            // Load all available security roles from petals view config files
            Properties rolesProps = PropertiesLoaderUtils.loadProperties(rolesResource);
            Object[] roles = rolesProps.keySet().toArray(new Object[0]);

            // Add default AUTH role
            GrantedAuthority[] arrayAuths = new GrantedAuthority[roles.length + 1];
            arrayAuths[0] = new GrantedAuthorityImpl("ROLE_AUTH");
            for (int j = 1; j < roles.length + 1; j++) {
                arrayAuths[j] = new GrantedAuthorityImpl("ROLE_" + roles[j - 1]);
            }

            return new User(assertion.getPrincipal().getName(), NON_EXISTENT_PASSWORD_VALUE, true,
                    true, true, true, arrayAuths);
        } catch (IOException e) {
            throw new UsernameNotFoundException("roles not found in config files.", e);
        }
    }

    public void setRolesResource(Resource rolesResource) {
        this.rolesResource = rolesResource;
    }

}
