/**
 * Petals View - Functional Supervision.
 * Copyright (c) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * PetalsViewServiceFactory.java
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.petalsview.util;

import javax.servlet.ServletContext;

import org.ow2.opensuit.core.session.OpenSuitSession;
import org.springframework.context.ApplicationContext;

import com.ebmwebsourcing.petalsview.service.dataexporter.exporter.ExporterReferential;
import com.ebmwebsourcing.petalsview.service.dataloader.Dataloader;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.service.flow.FlowStepManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowRefManager;
import com.ebmwebsourcing.petalsview.service.flowref.FlowStepRefManager;
import com.ebmwebsourcing.webcommons.user.api.service.RoleGroupManager;
import com.ebmwebsourcing.webcommons.user.api.service.RoleManager;
import com.ebmwebsourcing.webcommons.user.api.service.UserManager;
import com.ebmwebsourcing.webcommons.util.SpringUtil;

/**
 * @author ofabre - eBM WebSourcing
 * 
 */
public class PetalsViewServiceFactory {


    private final ApplicationContext springContext;


    private static PetalsViewServiceFactory instance;


    public static PetalsViewServiceFactory getInstance() {
        if (instance == null) {
            instance = new PetalsViewServiceFactory();
        }
        return instance;
    }


    private PetalsViewServiceFactory() {
        ServletContext servletContext = OpenSuitSession.getCurrentRequest().getSession()
                .getServletContext();
        this.springContext = SpringUtil.getWebApplicationContext(servletContext);
    }


    public FlowManager getFlowManager() {
        return (FlowManager) this.springContext.getBean("flowManager");
    }

    public FlowRefManager getFlowRefManager() {
        return (FlowRefManager) this.springContext.getBean("flowRefManager");
    }
    
    public UserManager getUserManager() {
        return (UserManager) this.springContext.getBean("userManager");
    }

    public RoleGroupManager getRoleGroupManager() {
        return (RoleGroupManager) this.springContext.getBean("roleGroupManager");
    }

    public RoleManager getRoleManager() {
        return (RoleManager) this.springContext.getBean("roleManager");
    }


	public Dataloader getDataLoader () {
	    return (Dataloader) this.springContext.getBean("dataloader");
	}
	
	public ExporterReferential getExporter (){
		return (ExporterReferential) this.springContext.getBean("dataexporter");
	}
	
	public FlowStepManager getFlowStepManager() {
        return (FlowStepManager) this.springContext.getBean("flowStepManager");
    }
	
	public FlowStepRefManager getFlowStepRefManager() {
        return (FlowStepRefManager) this.springContext.getBean("flowStepRefManager");
    }
}
