/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.admin;

import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import com.ebmwebsourcing.webcommons.user.api.service.UserException;
import com.ebmwebsourcing.webcommons.user.api.to.RoleGroupTO;
import com.ebmwebsourcing.webcommons.user.api.to.UserTO;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.ow2.opensuit.core.error.IError;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.error.NonLocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class UserBean {
    private final Logger logger = Logger.getLogger(this.getClass());
    private String id;
    private String login;
    private String pass;
    private String confirmPass;
    private String newPass;
    private String oldPass;
    private UserTO user;
    private List<UserTO> users;
    private boolean visible = false;
    private List<RoleGroupTO> allRoles;
    private List<RoleGroupTO> roles = new ArrayList();

    public void load(HttpServletRequest iRequest) throws LocalizedError {
        this.id = iRequest.getParameter("userId");
        try {
            this.user = PetalsViewServiceFactory.getInstance().getUserManager().getUser(this.id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.login = this.user.getName();
        this.pass = this.user.getPassword();
        this.roles = this.user.getListRoleGroup();
    }

    public void loadUsers() throws LocalizedError {
        try {
            this.users = PetalsViewServiceFactory.getInstance().getUserManager().getAllUser();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void loadRoleNotInUser() throws LocalizedError {
        try {
            this.allRoles = PetalsViewServiceFactory.getInstance().getRoleGroupManager().getRoleGroupNotInUser(this.id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void create() throws IError {
        this.user = new UserTO();
        this.user.setName(this.login);
        this.pass = this.passwordCrypting(this.pass);
        this.user.setPassword(this.pass);
        try {
            this.id = PetalsViewServiceFactory.getInstance().getUserManager().createUser(this.user);
        }
        catch (UserException e) {
            NonLocalizedError error = new NonLocalizedError("Can't create role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void save() throws IError {
        UserTO userTmp = new UserTO();
        userTmp.setName(this.login);
        userTmp.setId(this.id);
        userTmp.setPassword(this.pass);
        userTmp.setListRoleGroup(this.roles);
        try {
            this.id = PetalsViewServiceFactory.getInstance().getUserManager().updateUser(userTmp);
        }
        catch (UserException e) {
            this.login = this.user.getName();
            NonLocalizedError error = new NonLocalizedError("Can't save role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    public void delete(HttpServletRequest iRequest) throws IError {
        String idRole = iRequest.getParameter("userID");
        try {
            PetalsViewServiceFactory.getInstance().getUserManager().removeUser(idRole);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.loadUsers();
    }

    public void reset() {
    }

    public void refresh() throws IError {
        try {
            this.user = PetalsViewServiceFactory.getInstance().getUserManager().getUser(this.id);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.login = this.user.getName();
        this.pass = this.user.getPassword();
        this.roles = this.user.getListRoleGroup();
    }

    public void clear() {
        this.pass = null;
        this.confirmPass = null;
    }

    public void addRole(HttpServletRequest iRequest) throws IError {
        String idRole = iRequest.getParameter("ID");
        try {
            PetalsViewServiceFactory.getInstance().getUserManager().addRoleGroup(this.id, idRole);
        }
        catch (UserException e) {
            NonLocalizedError error = new NonLocalizedError("Can't save user.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.refresh();
    }

    public void addAllRoles() throws IError {
        for (RoleGroupTO rG : this.allRoles) {
            String idRole = rG.getId();
            try {
                PetalsViewServiceFactory.getInstance().getUserManager().addRoleGroup(this.id, idRole);
            }
            catch (UserException e) {
                NonLocalizedError error = new NonLocalizedError("Can't save user.", e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            catch (Throwable e) {
                this.logger.error((Object)e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        this.refresh();
    }

    public void removeRole(HttpServletRequest iRequest) throws IError {
        String idRole = iRequest.getParameter("ID");
        try {
            PetalsViewServiceFactory.getInstance().getUserManager().removeRoleGroup(this.id, idRole);
        }
        catch (UserException e) {
            NonLocalizedError error = new NonLocalizedError("Can't save role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        this.refresh();
    }

    public void removeAllRoles() throws IError {
        for (RoleGroupTO rG : this.roles) {
            String idRole = rG.getId();
            try {
                PetalsViewServiceFactory.getInstance().getUserManager().removeRoleGroup(this.id, idRole);
            }
            catch (UserException e) {
                NonLocalizedError error = new NonLocalizedError("Can't save role.", e.getMessage(), (Throwable)e);
                error.setType((short)0);
                throw error;
            }
            catch (Throwable e) {
                this.logger.error((Object)e.getMessage(), e);
                throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
            }
        }
        this.refresh();
    }

    public boolean canDeleteOrUpadateUser(String userName) {
        boolean verif = !userName.equals("admin");
        return verif;
    }

    public void validate() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        if (!this.pass.equalsIgnoreCase(this.confirmPass)) {
            errors.addItemError("userBean.confirmPass", (ValidationError)new LocalizedValidationError("validation.password"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void validateChange() throws ValidationErrors {
        ValidationErrors errors = new ValidationErrors();
        this.oldPass = this.passwordCrypting(this.oldPass);
        if (!this.newPass.equalsIgnoreCase(this.confirmPass)) {
            errors.addItemError("userBean.confirmPass", (ValidationError)new LocalizedValidationError("validation.password"));
        } else if (!this.oldPass.equalsIgnoreCase(this.pass)) {
            errors.addItemError("userBean.oldPass", (ValidationError)new LocalizedValidationError("validation.oldPassword"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void changePassword(HttpServletRequest iRequest) throws IError {
        this.user = new UserTO();
        this.user.setName(this.login);
        this.user.setId(this.id);
        this.newPass = this.passwordCrypting(this.newPass);
        this.user.setPassword(this.newPass);
        this.user.setListRoleGroup(this.roles);
        try {
            this.id = PetalsViewServiceFactory.getInstance().getUserManager().updateUser(this.user);
        }
        catch (UserException e) {
            NonLocalizedError error = new NonLocalizedError("Can't save role.", e.getMessage(), (Throwable)e);
            error.setType((short)0);
            throw error;
        }
        catch (Throwable e) {
            this.logger.error((Object)e.getMessage(), e);
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
    }

    private String passwordCrypting(String password) {
        byte[] uniqueKey = password.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("No MD5 support in this VM.");
        }
        StringBuilder hashString = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
                continue;
            }
            hashString.append(hex.substring(hex.length() - 2));
        }
        return hashString.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getConfirmPass() {
        return this.confirmPass;
    }

    public void setConfirmPass(String confirmPass) {
        this.confirmPass = confirmPass;
    }

    public String getNewPass() {
        return this.newPass;
    }

    public void setNewPass(String newPass) {
        this.newPass = newPass;
    }

    public String getOldPass() {
        return this.oldPass;
    }

    public void setOldPass(String oldPass) {
        this.oldPass = oldPass;
    }

    public UserTO getUser() {
        return this.user;
    }

    public void setUser(UserTO user) {
        this.user = user;
    }

    public List<UserTO> getUsers() {
        return this.users;
    }

    public void setUsers(List<UserTO> users) {
        this.users = users;
    }

    public List<RoleGroupTO> getAllRoles() {
        return this.allRoles;
    }

    public void setAllRoles(List<RoleGroupTO> allRoles) {
        this.allRoles = allRoles;
    }

    public List<RoleGroupTO> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleGroupTO> roles) {
        this.roles = roles;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

