/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.petalsview.gui.beans.supervision;

import com.ebmwebsourcing.petalsview.persistence.model.flow.Flow;
import com.ebmwebsourcing.petalsview.service.flow.FlowManager;
import com.ebmwebsourcing.petalsview.util.PetalsViewServiceFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.ow2.opensuit.core.error.LocalizedError;
import org.ow2.opensuit.core.validation.LocalizedValidationError;
import org.ow2.opensuit.core.validation.ValidationError;
import org.ow2.opensuit.core.validation.ValidationErrors;

public class ListOfFlows {
    private static int[] ALL_STATUS = new int[]{0, 1, 2};
    private List<Flow> flows;
    private Date before;
    private Date after;
    private FlowManager flowManager = PetalsViewServiceFactory.getInstance().getFlowManager();
    private String css;

    public void loadAll() throws Exception {
        this.setupFilterToday();
        this.flows = this.flowManager.loadAllStartedWithDateFilter(this.after, this.before);
    }

    private void setupFilterToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.after = cal.getTime();
        cal.add(5, 1);
        this.before = cal.getTime();
    }

    public String getShortName(Flow flow) {
        String shortName = flow.getIdpetals();
        if (shortName != null) {
            if (shortName.length() > 30) {
                shortName = shortName.substring(0, 27) + "...";
            }
        } else {
            shortName = " ";
        }
        return shortName;
    }

    public String getName(Flow flow) {
        String name = flow.getIdpetals();
        return name;
    }

    public void viewAllFlow() throws Exception {
        this.after = null;
        this.before = null;
        this.flows = new ArrayList();
        this.css = "status_ok";
        this.flows = this.flowManager.loadAll();
    }

    public void validateFilter() throws ValidationErrors {
        Date now = new Date();
        ValidationErrors errors = new ValidationErrors();
        if (this.after != null && this.after.after(now)) {
            errors.addItemError("flows.after", (ValidationError)new LocalizedValidationError("validation.date.future"));
        }
        if (this.before != null && this.after != null && this.after.after(this.before)) {
            errors.addItemError("flows.before", (ValidationError)new LocalizedValidationError("validation.date.negative_range"));
        }
        if (errors.hasErrors()) {
            throw errors;
        }
    }

    public void applyFilter() throws Exception {
        this.flows = this.flowManager.loadAllStartedWithDateFilter(this.after, this.before);
    }

    public void refresh() throws Exception {
        if (this.after == null && this.before == null) {
            this.viewAllFlow();
        } else {
            this.setupFilterToday();
            this.flows = this.flowManager.loadAllStartedWithDateFilter(this.after, this.before);
        }
    }

    public void download(HttpServletResponse response) throws LocalizedError, IOException {
        response.setContentType("text/csv");
        Locale locale = Locale.FRANCE;
        DateFormat dateFormat = DateFormat.getDateInstance(3, locale);
        Date date = new Date();
        PrintWriter output = response.getWriter();
        try {
            output.print("Type ;");
            output.print("Instance ;");
            output.print("StartDate ;");
            output.print("EndDate ;");
            output.print("Status ;");
            output.println();
            for (Flow f : this.flows) {
                output.print(f.getType() + ";");
                output.print(f.getId() + ";");
                date.setTime(f.getStartDate());
                output.print(date + ";");
                date.setTime(f.getEndDate());
                String dateS = dateFormat.format(date);
                output.print(dateS + ";");
                int status = this.getUiStatus(f.getStatus().intValue());
                String s = null;
                if (status == 0) {
                    s = "Success";
                }
                output.print(s + ";");
                output.println();
            }
        }
        catch (Exception e) {
            throw new LocalizedError("database_technical", new Object[]{e.getMessage()});
        }
        output.flush();
        output.close();
    }

    public List<Flow> getFlows() {
        return this.flows;
    }

    public static int[] getAllStatus() {
        return ALL_STATUS;
    }

    public Date getBefore() {
        return this.before;
    }

    public void setBefore(Date before) {
        this.before = before;
    }

    public Date getAfter() {
        return this.after;
    }

    public void setAfter(Date after) {
        this.after = after;
    }

    public int getUiStatus(int status) {
        if (status == 0) {
            return 0;
        }
        if (status == -1) {
            return 2;
        }
        return 1;
    }

    public String getCss() {
        return this.css;
    }

    public void setCss(String css) {
        this.css = css;
    }
}

