/**
 * su-generator - JBI Su Management - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petals.services.generation.cdk5;

import com.ebmwebsourcing.petals.services.generation.JbiBeanDelegate;

/**
 * @author Vincent Zurczak - EBM WebSourcing
 */
public abstract class CdkConsumes5BeanDelegate extends JbiBeanDelegate {

	String operation;
	String timeout;
	MEP mep;


	/**
	 * Constructor.
	 * <p>
	 * Must be called by sub-classes.
	 * </p>
	 */
	public CdkConsumes5BeanDelegate() {
		super();
		addNamespace( "petalsCDK", "http://petals.ow2.org/components/extensions/version-5" );
	}


	/**
	 * The MEP values.
	 */
	public enum MEP {
		InOut, InOnly, RobustInOnly, InOptionalOut;
	}


	/* (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate#getCdkSection()
	 */
	@Override
	public String getCdkSection() {

		String result = "";

		if( this.operation != null
					&& this.operation.trim().length() > 0 )
			result += "\t\t\t<petalsCDK:operation>operation:" + this.operation + "</petalsCDK:operation>\n";

		if( this.timeout != null && ! "0".equals( this.timeout.trim()))
			result += "\t\t\t<petalsCDK:timeout>" + this.timeout + "</petalsCDK:timeout>\n";

		if( this.mep != null ) {
			result += "\t\t\t<petalsCDK:mep>" + this.mep + "</petalsCDK:mep>\n";
		} else {
		    addNamespace("xsi","http://www.w3.org/2001/XMLSchema-instance");
		    result += "\t\t\t<petalsCDK:mep xsi:nil=\"true\"></petalsCDK:mep>\n";
		}

		return result;
	}


	/**
	 * @return the operation
	 */
	public String getOperation() {
		return this.operation;
	}


	/**
	 * @param operation the operation to set
	 */
	public void setOperation( String operation ) {
		this.operation = operation;
	}


	/**
	 * @param operationNsUri the operationNsUri to set
	 */
	public void setOperationNsUri( String operationNsUri ) {
		addNamespace( "operation", operationNsUri );
	}


	/**
	 * @return the timeout
	 */
	public String getTimeout() {
		return this.timeout;
	}


	/**
	 * @param timeout the timeout to set
	 */
	public void setTimeout( String timeout ) {
		this.timeout = timeout;
	}


	/**
	 * @return the mep
	 */
	public MEP getMep() {
		return this.mep;
	}


	/**
	 * @param mep the mep to set
	 */
	public void setMep( MEP mep ) {
		this.mep = mep;
	}


	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate#isProvides()
	 */
	@Override
	public boolean isProvides() {
		return false;
	}
}
