/**
 * su-generator - JBI Su Management - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.petals.services.generation.cdk5.components;

import com.ebmwebsourcing.petals.services.generation.cdk5.CdkProvides5BeanDelegate;

/**
 * @author Vincent Zurczak - EBM WebSourcing
 */
public class SoapProvides40 extends CdkProvides5BeanDelegate {

	private SoapVersion soapVersion = SoapVersion.v11;
	private String serviceAddress;


	/**
	 * The possible SOAP versions that can be used in the SOAP component.
	 */
	public static enum SoapVersion {
		v11, v12;

		@Override
		public String toString() {
			if( this == v12 )
				return "1.2";
			return "1.1";
		}
	}


	/**
	 * Constructor.
	 */
	public SoapProvides40() {
		super();
		addNamespace( "soap", "http://petals.ow2.org/components/soap/version-4" );
	}


	/* (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate
	 * #getComponentSection()
	 */
	@Override
	public String getComponentSection() {

		String result = "";
		result += "\t\t\t<soap:address>" + this.serviceAddress + "</soap:address>\n";
		result += "\t\t\t<soap:soap-version>" + this.soapVersion.toString() + "</soap:soap-version>\n";
		result += "\t\t\t<soap:add-root>false</soap:add-root>\n";
		result += "\t\t\t<soap:chunked-mode>false</soap:chunked-mode>\n";
		result += "\t\t\t<soap:cleanup-transport>true</soap:cleanup-transport>\n";
		result += "\t\t\t<soap:mode>SOAP</soap:mode>\n";

		return result;
	}


	/**
	 * @return the soapVersion
	 */
	public SoapVersion getSoapVersion() {
		return this.soapVersion;
	}


	/**
	 * @param soapVersion the soapVersion to set
	 */
	public void setSoapVersion( SoapVersion soapVersion ) {
		this.soapVersion = soapVersion;
	}


	/**
	 * @return the serviceAddress
	 */
	public String getServiceAddress() {
		return this.serviceAddress;
	}


	/**
	 * @param serviceAddress the serviceAddress to set
	 */
	public void setServiceAddress( String serviceAddress ) {
		this.serviceAddress = serviceAddress;
	}


	/*
	 * (non-Javadoc)
	 * @see com.ebmwebsourcing.jbi.core.jbixml.JbiBeanDelegate#getSuType()
	 */
	@Override
	public String getSuType() {
		return "SOAP";
	}
}
