/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.contextualmenu;


import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IContextualMenuConfiguration;
import com.ebmwebsourcing.geasytools.geasyui.api.contextualmenu.IHasContextualMenu;
import com.ebmwebsourcing.geasytools.geasyui.api.core.Direction;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.IDraggableElement;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IAcceptedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragMoveEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStartEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IDragStopEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedAfterDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.api.draggable.events.IRefusedBeforeDropEvent;
import com.ebmwebsourcing.geasytools.geasyui.impl.draggable.DragHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DoubleClickEvent;
import com.google.gwt.event.dom.client.DoubleClickHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.RootPanel;

public abstract class ContextualMenu extends Composite implements IContextualMenu{
	
	private IHasContextualMenu hasContextualMenu;
	private IContextualMenuConfiguration config;
	protected AbsolutePanel mainPanel;
	private Timer timer;
	
	boolean added = false;

	private IContextualMenu parentMenu;
	
	public ContextualMenu(IHasContextualMenu hasContextualMenu) {
		this.hasContextualMenu 	= hasContextualMenu;
		this.mainPanel 			= new AbsolutePanel();
		this.config 			= new Configuration();
		this.config.setDisplayTime(300);
		this.config.setHeight(140);
		this.config.setWidth(35);
		initWidget(mainPanel);
		
		init();

	}
	
	public ContextualMenu(IHasContextualMenu hasContextualMenu,IContextualMenu parentMenu) {
		
		this.hasContextualMenu 	= hasContextualMenu;
		this.mainPanel 			= new AbsolutePanel();
		this.config 			= new Configuration();
		this.config.setDisplayTime(100);
		this.config.setHeight(140);
		this.config.setWidth(35);
		initWidget(mainPanel);
		
		
		this.parentMenu = parentMenu;
		
		init();
	}
	
	public ContextualMenu(IHasContextualMenu hasContextualMenu,IContextualMenuConfiguration config) {
		this(hasContextualMenu);
		this.config = config;
	}
	
	@Override
	public IContextualMenuConfiguration getConfiguration() {
		return config;
	}

	@Override
	public IHasContextualMenu getHasContextualDragProxyMenu() {
		return hasContextualMenu;
	}

	protected void init(){
		

		mainPanel.setPixelSize(config.getWidth(), config.getHeight());
	
	
		this.hide();
		
		this.timer = new Timer() {
			
			@Override
			public void run() {
				
				mainPanel.setVisible(false);
				
			}
		};
		
		
		this.hasContextualMenu.addMouseOverHandler(new MouseOverHandler() {
			
			public void onMouseOver(MouseOverEvent arg0) {
				
				if (hasContextualMenu.getMenuDirection()==null || hasContextualMenu.getMenuDirection()==Direction.E){
					
					int panelX = (int) ((hasContextualMenu.getAbsoluteLeft()) + hasContextualMenu.getWidth()) + 5;
					int panelY = (int) ((hasContextualMenu.getAbsoluteTop()));
				
					
					if (added==false){
						
						RootPanel.get().add(ContextualMenu.this);
						
						added = true;
					}
					
					RootPanel.get().setWidgetPosition(ContextualMenu.this, panelX, panelY);
					show();
					
				}else if (hasContextualMenu.getMenuDirection()==Direction.W){
					
					int panelX = (int) (hasContextualMenu.getAbsoluteLeft() - ContextualMenu.this.config.getWidth() + 5);
					int panelY = (int) ((hasContextualMenu.getAbsoluteTop()));
				
					
					if (added==false){
						
						RootPanel.get().add(ContextualMenu.this);
						
						added = true;
					}
					
					RootPanel.get().setWidgetPosition(ContextualMenu.this, panelX, panelY);
					show();					
					
					
				}
				
			}

		});
		
		
		this.hasContextualMenu.addMouseOutHandler(new MouseOutHandler() {
			
			public void onMouseOut(MouseOutEvent arg0) {

				timer.schedule(config.getDisplayTime());
	
			}
		});
		
			if (hasContextualMenu instanceof IDraggableElement){
			
				IDraggableElement hd = (IDraggableElement) hasContextualMenu;
				
				hd.addDragHandler(new DragHandler() {
						
						public void onStop(IDragStopEvent event) {
							
							hide();
							
						}
						
						public void onStart(IDragStartEvent event) {
							
							hide();
							
						}
						
						public void onMove(IDragMoveEvent event) {
							
							hide();
							
						}

						@Override
						public void onAcceptedAfterDrop(
								IAcceptedAfterDropEvent event) {}

						@Override
						public void onAcceptedBeforeDrop(
								IAcceptedBeforeDropEvent event) {}

						@Override
						public void onRefusedAfterDrop(
								IRefusedAfterDropEvent event) {}

						@Override
						public void onRefusedBeforeDrop(
								IRefusedBeforeDropEvent event) {}
					
				});
				
			}
				
		this.addClickHandler(new ClickHandler() {
			
			public void onClick(ClickEvent arg0) {
				arg0.stopPropagation();
				
			}
		});
		
		this.addMouseDownHandler(new MouseDownHandler() {
			
			public void onMouseDown(MouseDownEvent arg0) {
				
				arg0.stopPropagation();
				
			}
		});
		
		this.addMouseOutHandler(new MouseOutHandler() {
			
			public void onMouseOut(MouseOutEvent arg0) {
				
				hide();
				
				if (parentMenu!=null) parentMenu.asWidget().setVisible(false);
					
			}
		});
		
		this.addMouseOverHandler(new MouseOverHandler() {
			
			public void onMouseOver(MouseOverEvent arg0) {
				
				timer.cancel();
		
				if (parentMenu!=null) parentMenu.asWidget().setVisible(true);
			
			}
		});
		
		this.addMouseMoveHandler(new MouseMoveHandler() {
			
			@Override
			public void onMouseMove(MouseMoveEvent event) {
				
				
				if (parentMenu!=null) parentMenu.asWidget().setVisible(true);
				
			}
		});
		
		
		
	
	}
	
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}

	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}

	public HandlerRegistration addDoubleClickHandler(DoubleClickHandler handler) {
		return addDomHandler(handler, DoubleClickEvent.getType());
	}
	
	
	@Override
	public void show() {
		this.setVisible(true);
	}
	
	@Override
	public void hide() {
		this.setVisible(false);
	}


	@Override
	public float getHeight() {
		return this.getOffsetHeight();
	}


	@Override
	public Direction getMenuDirection() {
		// TODO Auto-generated method stub
		return null;
	}


	@Override
	public float getWidth() {
		return this.getOffsetWidth();
	}
	
	@Override
	public IContextualMenu getParentMenu() {
		return parentMenu;
	}
	
	
}
