/**
 * geasy-ui - A library for user interraction in GWT - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.geasyui.impl.droppable;

import com.ebmwebsourcing.geasytools.geasyui.api.core.IPoint;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDDManager;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppable;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.IDroppableDefaultHandlers;
import com.ebmwebsourcing.geasytools.geasyui.api.droppable.events.IDropHandler;
import com.ebmwebsourcing.geasytools.geasyui.api.uipanel.IUIPanel;
import com.ebmwebsourcing.geasytools.geasyui.impl.core.Point;
import com.ebmwebsourcing.geasytools.geasyui.impl.selectable.Selectable;

public abstract class Droppable extends Selectable implements IDroppable{
	
	private DroppableDefaultHandlers droppableDefaultHandlers;
	
	public Droppable(IUIPanel uiPanel, String id) {
		super(uiPanel, id);
		this.droppableDefaultHandlers = new DroppableDefaultHandlers(this);
	}



	@Override
	public void addDropHandler(IDropHandler dropHandler) {
		handlerManager.addHandler(OverEvent.TYPE,(DropHandler) dropHandler);
		handlerManager.addHandler(OutEvent.TYPE,(DropHandler) dropHandler);
		handlerManager.addHandler(DropAcceptedEvent.TYPE, (DropHandler) dropHandler);
		handlerManager.addHandler(DropRefusedEvent.TYPE, (DropHandler) dropHandler);
	}


	@Override
	public IDDManager getDDManager() {
		return this.getUIPanel().getDDManager();
	}

	@Override
	public IDroppableDefaultHandlers getDroppableDefaultHandlers() {
		return droppableDefaultHandlers;
	}


	public IPoint getNorthWestPoint() {
		Point p  = new Point(this.getAbsoluteLeft(), this.getAbsoluteTop());

		return p;
	}

	public IPoint getSouthEastPoint() {
		
		Point p = new Point(this.getAbsoluteLeft()+this.getWidth(), this.getAbsoluteTop()+this.getHeight());

		return p;
	}





}
