/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.file.explorer;

import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.button.ToolbarButton;
import com.ebmwebsourcing.geasytools.gwtextwidgets.file.FilePanel;
import com.ebmwebsourcing.geasytools.gwtextwidgets.file.FolderPanel;
import com.ebmwebsourcing.geasytools.widgets.core.api.button.IButton;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFile;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.IFolder;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFilePanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFileSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFilesLoadedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderPanelHandler;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFolderSelectedEvent;
import com.ebmwebsourcing.geasytools.widgets.ext.api.file.events.IFoldersLoadedEvent;
import com.google.gwt.event.shared.GwtEvent;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.layout.HorizontalLayout;

public class FileExplorerPanel
		extends
		com.ebmwebsourcing.geasytools.widgets.ext.impl.file.explorer.FileExplorerPanel {
	

	private FilePanel filePanel;
	private FolderPanel folderPanel;
	private Panel mainPanel;
	private ToolbarButton cancelBtn;
	private ToolbarButton validateBtn;
	
	public FileExplorerPanel() {
		
		
		this.mainPanel  = new Panel();
		this.mainPanel.setWidth(650);
		/////////Files Panel
		this.filePanel 		= new FilePanel();
		this.filePanel.setWidth(325);
		this.filePanel.setHeight(300);

		
		//forward events
		this.filePanel.addHandler(new IFilePanelHandler() {
			
			@Override
			public void onFilesLoaded(IFilesLoadedEvent event) {
					
				fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onFilesSelected(IFileSelectedEvent event) {
				
				fireEvent((GwtEvent<?>) event);
				
			}
		});
		
		/////////Folder Panel
		this.folderPanel 	= new FolderPanel();
		this.folderPanel.setWidth(300);
		this.folderPanel.setHeight(300);
		//forward events
		this.folderPanel.addHandler(new IFolderPanelHandler() {
			
			@Override
			public void onFoldersLoaded(IFoldersLoadedEvent event) {
				
				fireEvent((GwtEvent<?>) event);
				
			}
			
			@Override
			public void onFolderSelected(IFolderSelectedEvent event) {
				
				fireEvent((GwtEvent<?>) event);
				
			}
		});
		
//		this.horizontalPanel 			= new HorizontalPanel();
//		
//		this.horizontalPanel.setCellWidth(folderPanel, "300px");
//		
//		
//		
//		
//		this.horizontalPanel.setCellHorizontalAlignment(folderPanel,HasHorizontalAlignment.ALIGN_RIGHT);
//
//		this.horizontalPanel.add(folderPanel);
//		this.horizontalPanel.add(filePanel);

		
//		this.mainPanel.add(horizontalPanel);
		
		

		mainPanel.setLayout(new HorizontalLayout(25));
		mainPanel.add(folderPanel);
		mainPanel.add(filePanel);

		
		Toolbar tb  = new Toolbar();
		tb.addFill();
		tb.addButton((com.gwtext.client.widgets.ToolbarButton) getValidateBtn());
		tb.addButton((com.gwtext.client.widgets.ToolbarButton) getCancelBtn());
		
		
		mainPanel.setBottomToolbar(tb);
		
		initWidget(mainPanel);
	}
	
	@Override
	public IButton getCancelBtn() {
		
		if (cancelBtn==null){
			this.cancelBtn = new ToolbarButton();
			this.cancelBtn.setText("Cancel");
		}
		
		return cancelBtn;
	}


	@Override
	public IButton getValidateBtn() {
		
		if (validateBtn==null){
			
			this.validateBtn = new ToolbarButton();
			this.validateBtn.setText("Validate");
			
		}
		
		
		return validateBtn;
	}
	
	@Override
	public void setTitle(String title) {
		this.mainPanel.setTitle(title);
	}
	
	@Override
	public void setHeight(int height) {
		this.mainPanel.setHeight(height);
	}

	@Override
	public void setWidth(int width) {
		this.mainPanel.setWidth(width);
	}

	@Override
	public void setFiles(List<IFile> files) {
		this.filePanel.setFiles(files);
	}

	@Override
	public void setFolders(List<IFolder> folders) {
		this.folderPanel.setFolders(folders);
	}

}
