/**
 * geasy-widgets-gwtext - Geasy widgets implementation with GWT-Ext library - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.ebmwebsourcing.geasytools.gwtextwidgets.grid;

import java.util.ArrayList;
import java.util.List;

import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AddElementEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.BeforeEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.CellClickEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.AfterEditRecordEvent;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.EditableGridHandler;
import com.ebmwebsourcing.geasytools.gwtextwidgets.grid.events.RemoveElementEvent;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Record;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.event.EditorGridListener;

public abstract class AbstractEditableGrid<T> extends AbstractCheckBoxGrid<T>{
	
	public AbstractEditableGrid() {
		super();
		
	}

	@Override
	protected void buildGrid() {
		super.buildGrid();
		
		Toolbar toolbar = new Toolbar();  
		
		if (hasAddBtn()){
		
			ToolbarButton btnAdd = new ToolbarButton(getAddText(), new ButtonListenerAdapter() {  
			    public void onClick(Button button, EventObject e) {  
			    	
			    	T newDefaultRecordObject        = getNewDefaultRecord();
			    	
			    	Object[] newObject = convertDataToObjectWithObjectRef(newDefaultRecordObject);
			    	
			        Record newRecord = recordDef.createRecord(newObject);
			        
			        gridPanel.stopEditing();
			        int index = 0;
			        
			        store.insert(index, newRecord); 
			        
			        data.add(newDefaultRecordObject);
			        
			        fireEvent(new AddElementEvent<Record>(newRecord,index));
			        
			       
			    }  
			});  
		
			toolbar.addButton(btnAdd);
			
		}
		
		
		if (hasRemoveBtn()){
			
			ToolbarButton btnRemove = new ToolbarButton(getRemoveText(),new ButtonListenerAdapter(){
				
				@Override
				public void onClick(Button button, EventObject e) {
					
					Record[] records = cbSelectionModel.getSelections();
					
			        for (int i = 0; i < records.length; i++) {  
			            Record record = records[i];  
			        
			            store.remove(record);
			            
			            fireEvent(new RemoveElementEvent<Record>(record, i));
			            
			        }
					
				}
				
			});
		
			toolbar.addButton(btnRemove);
			
		}
		
		
		gridPanel.addEditorGridListener(new EditorGridListener() {
			
			@Override
			public void onAfterEdit(GridPanel grid, Record record, String field,
					Object newValue, Object oldValue, int rowIndex, int colIndex) {
				
				AfterEditRecordEvent<Record> r = new AfterEditRecordEvent<Record>(record, rowIndex,colIndex); 
				
				r.setNewValue(newValue);
				r.setOldValue(oldValue);
				
				fireEvent(r);
				
			}
			
			@Override
			public boolean doValidateEdit(GridPanel grid, Record record, String field,
					Object value, Object originalValue, int rowIndex, int colIndex) {

				return true;
			}
			
			@Override
			public boolean doBeforeEdit(GridPanel grid, Record record, String field,
					Object value, int rowIndex, int colIndex) {
				
				BeforeEditRecordEvent<Record> r = new BeforeEditRecordEvent<Record>(record, rowIndex, colIndex);
				
				fireEvent(r);
				
				
				return true;
			}
		});
		
		
		


		
		gridPanel.setTopToolbar(toolbar);
	}
	
	
	protected abstract String getAddText();
	
	protected abstract String getRemoveText();
	
	protected boolean hasAddBtn(){
		return true;
	}
	
	protected boolean hasRemoveBtn(){
		return true;
	}
	
	protected abstract T getNewDefaultRecord();
	

	@Override
	public List<T> getSelectedValues() {
		getValues();//used to bind
		return super.getSelectedValues();
	}
	
	public List<T> getValues(){
		
		Record[] records = gridPanel.getStore().getRecords();
		
		ArrayList<T> values = new ArrayList<T>();
		
		
		for(int i = 0;i<records.length;i++){
			
			Record record = records[i];
			
			T value		  = (T) record.getAsObject(OBJECT_REF);
			
			bind(record, value);
			
			values.add(value);
		
		}
		
		
		return values;
	}
	
	protected abstract void bind(Record record,T value);
	
	public void addHandler(EditableGridHandler handler){
		addHandler(handler,	CellClickEvent.TYPE);
		addHandler(handler, AddElementEvent.TYPE);
		addHandler(handler, RemoveElementEvent.TYPE);
		addHandler(handler,	AfterEditRecordEvent.TYPE);
		addHandler(handler,	BeforeEditRecordEvent.TYPE);
	}
	
}
