/**
 * model-manager - Handles models on client side for stuffs like undo/redo, methods observers, uibinding ... - Copyright (C) 2010 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind;

import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.lookup.IHasLookup;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelbinder.IHasModelBinder;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.modelscope.IHasScope;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.observable.IObservable;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.reflection.IHasReflection;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.client.uibinder.IHasEditor;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.lookup.HasLookupProxyGenerator;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.modelbinder.WatchedModelProxyGenerator;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.observable.ObservableProxyGenerator;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.reflection.ReflectionProxyGenerator;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.scope.ScopeModelProxyGenerator;
import com.ebmwebsourcing.geasytools.modeleditor.modelmanager.rebind.uibinder.HasEditorProxyGenerator;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.GeneratorContext;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.TreeLogger.Type;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;

public class GeneratorDelegate extends Generator {
	
	private ReflectionProxyGenerator reflectionProxyGenerator;
	private WatchedModelProxyGenerator watchedModelProxyGenerator;
	private HasEditorProxyGenerator hasEditorProxyGenerator;
	private ScopeModelProxyGenerator scopeModelProxyGenerator;
	private ObservableProxyGenerator observableProxyGenerator;
	private HasLookupProxyGenerator lookupProxyGenerator;
	
	public GeneratorDelegate() {
		
		this.reflectionProxyGenerator   = new ReflectionProxyGenerator();
		this.watchedModelProxyGenerator = new WatchedModelProxyGenerator();
		this.hasEditorProxyGenerator 	= new HasEditorProxyGenerator();
		this.scopeModelProxyGenerator   = new ScopeModelProxyGenerator();
		this.observableProxyGenerator 	= new ObservableProxyGenerator();
		this.lookupProxyGenerator		= new HasLookupProxyGenerator();
		
	}
	
	@Override
	public String generate(TreeLogger logger, GeneratorContext context,
			String typeName) throws UnableToCompleteException {

		String superClass = typeName;

		try{
		
			JClassType type 				= context.getTypeOracle().getType(typeName);
			JClassType hasReflectionType	= context.getTypeOracle().getType(IHasReflection.class.getCanonicalName());
			JClassType hasModelBinderType 	= context.getTypeOracle().getType(IHasModelBinder.class.getCanonicalName());
			JClassType hasEditor			= context.getTypeOracle().getType(IHasEditor.class.getCanonicalName());
			JClassType hasScopeType			= context.getTypeOracle().getType(IHasScope.class.getCanonicalName());
			JClassType observableType		= context.getTypeOracle().getType(IObservable.class.getCanonicalName());
			JClassType hasLookup			= context.getTypeOracle().getType(IHasLookup.class.getCanonicalName());
			
			if (type.isAssignableTo(hasReflectionType)){

				logger.log(Type.INFO, "Type "+type+" is assignable to "+hasReflectionType);
				reflectionProxyGenerator.setType(type);
				superClass = reflectionProxyGenerator.generate(logger, context, superClass);				
				
			}
			
			

			if (type.isAssignableTo(observableType)){
				
				logger.log(Type.INFO, "Type "+type+" is assignable to "+observableType);
				observableProxyGenerator.setType(type);
				superClass = observableProxyGenerator.generate(logger, context, superClass);
			
			}

			
			if (type.isAssignableTo(hasLookup)){
				logger.log(Type.INFO, "Type "+type+" is assignable to "+hasLookup);
				lookupProxyGenerator.setType(type);
				superClass = lookupProxyGenerator.generate(logger, context, superClass);
			
			}
			
			if (type.isAssignableTo(hasModelBinderType)){

				logger.log(Type.INFO, "Type "+type+" is assignable to "+hasModelBinderType);
				watchedModelProxyGenerator.setType(type);
				superClass = watchedModelProxyGenerator.generate(logger, context, superClass);


			}
			
			if (type.isAssignableTo(hasEditor)){
				
				logger.log(Type.INFO, "Type "+type+" is assignable to "+hasEditor);
				hasEditorProxyGenerator.setType(type);
				superClass = hasEditorProxyGenerator.generate(logger, context, superClass); 


			}
			

			if (type.isAssignableTo(hasScopeType)){
				logger.log(Type.INFO, "Type "+type+" is assignable to "+hasScopeType);
				scopeModelProxyGenerator.setType(type);
				superClass = scopeModelProxyGenerator.generate(logger, context, superClass);
			
			}




		} catch (NotFoundException e) {
		
			e.printStackTrace();
		
		}
		

		
		return superClass;
	}

}
